@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.AssociationOutputLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property s3BucketName The S3 bucket name.
 * @property s3KeyPrefix The S3 bucket prefix. Results stored in the root if not configured.
 * @property s3Region The S3 bucket region.
 * Targets specify what instance IDs or tags to apply the document to and has these keys:
 */
public data class AssociationOutputLocationArgs(
    public val s3BucketName: Output<String>,
    public val s3KeyPrefix: Output<String>? = null,
    public val s3Region: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.AssociationOutputLocationArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.AssociationOutputLocationArgs =
        com.pulumi.aws.ssm.inputs.AssociationOutputLocationArgs.builder()
            .s3BucketName(s3BucketName.applyValue({ args0 -> args0 }))
            .s3KeyPrefix(s3KeyPrefix?.applyValue({ args0 -> args0 }))
            .s3Region(s3Region?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssociationOutputLocationArgs].
 */
@PulumiTagMarker
public class AssociationOutputLocationArgsBuilder internal constructor() {
    private var s3BucketName: Output<String>? = null

    private var s3KeyPrefix: Output<String>? = null

    private var s3Region: Output<String>? = null

    /**
     * @param value The S3 bucket name.
     */
    @JvmName("tsirdgwumfvjvrsg")
    public suspend fun s3BucketName(`value`: Output<String>) {
        this.s3BucketName = value
    }

    /**
     * @param value The S3 bucket prefix. Results stored in the root if not configured.
     */
    @JvmName("asutdkivlshoifly")
    public suspend fun s3KeyPrefix(`value`: Output<String>) {
        this.s3KeyPrefix = value
    }

    /**
     * @param value The S3 bucket region.
     * Targets specify what instance IDs or tags to apply the document to and has these keys:
     */
    @JvmName("vcnddmngbicaglqb")
    public suspend fun s3Region(`value`: Output<String>) {
        this.s3Region = value
    }

    /**
     * @param value The S3 bucket name.
     */
    @JvmName("hewysrwmksyccxrn")
    public suspend fun s3BucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3BucketName = mapped
    }

    /**
     * @param value The S3 bucket prefix. Results stored in the root if not configured.
     */
    @JvmName("howeipoorkrlepku")
    public suspend fun s3KeyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3KeyPrefix = mapped
    }

    /**
     * @param value The S3 bucket region.
     * Targets specify what instance IDs or tags to apply the document to and has these keys:
     */
    @JvmName("ptmnhqbsldumdpmc")
    public suspend fun s3Region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Region = mapped
    }

    internal fun build(): AssociationOutputLocationArgs = AssociationOutputLocationArgs(
        s3BucketName = s3BucketName ?: throw PulumiNullFieldException("s3BucketName"),
        s3KeyPrefix = s3KeyPrefix,
        s3Region = s3Region,
    )
}
