@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dailySettings
 * @property monthlySettings (Optional) Information about on-call rotations that recur monthly. See Monthly Settings for more details.
 * @property numberOfOnCalls (Required) The number of contacts, or shift team members designated to be on call concurrently during a shift.
 * @property recurrenceMultiplier (Required) The number of days, weeks, or months a single rotation lasts.
 * @property shiftCoverages (Optional) Information about the days of the week that the on-call rotation coverage includes. See Shift Coverages for more details.
 * @property weeklySettings (Optional) Information about on-call rotations that recur weekly. See Weekly Settings for more details.
 */
public data class ContactsRotationRecurrenceArgs(
    public val dailySettings: Output<List<ContactsRotationRecurrenceDailySettingArgs>>? = null,
    public val monthlySettings: Output<List<ContactsRotationRecurrenceMonthlySettingArgs>>? = null,
    public val numberOfOnCalls: Output<Int>,
    public val recurrenceMultiplier: Output<Int>,
    public val shiftCoverages: Output<List<ContactsRotationRecurrenceShiftCoverageArgs>>? = null,
    public val weeklySettings: Output<List<ContactsRotationRecurrenceWeeklySettingArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceArgs =
        com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceArgs.builder()
            .dailySettings(
                dailySettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .monthlySettings(
                monthlySettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .numberOfOnCalls(numberOfOnCalls.applyValue({ args0 -> args0 }))
            .recurrenceMultiplier(recurrenceMultiplier.applyValue({ args0 -> args0 }))
            .shiftCoverages(
                shiftCoverages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .weeklySettings(
                weeklySettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContactsRotationRecurrenceArgs].
 */
@PulumiTagMarker
public class ContactsRotationRecurrenceArgsBuilder internal constructor() {
    private var dailySettings: Output<List<ContactsRotationRecurrenceDailySettingArgs>>? = null

    private var monthlySettings: Output<List<ContactsRotationRecurrenceMonthlySettingArgs>>? = null

    private var numberOfOnCalls: Output<Int>? = null

    private var recurrenceMultiplier: Output<Int>? = null

    private var shiftCoverages: Output<List<ContactsRotationRecurrenceShiftCoverageArgs>>? = null

    private var weeklySettings: Output<List<ContactsRotationRecurrenceWeeklySettingArgs>>? = null

    /**
     * @param value
     */
    @JvmName("ijiapqcjldokhsfx")
    public suspend fun dailySettings(`value`: Output<List<ContactsRotationRecurrenceDailySettingArgs>>) {
        this.dailySettings = value
    }

    @JvmName("eykscredookvxexy")
    public suspend fun dailySettings(vararg values: Output<ContactsRotationRecurrenceDailySettingArgs>) {
        this.dailySettings = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("xgxmdlmnbhjugond")
    public suspend fun dailySettings(values: List<Output<ContactsRotationRecurrenceDailySettingArgs>>) {
        this.dailySettings = Output.all(values)
    }

    /**
     * @param value (Optional) Information about on-call rotations that recur monthly. See Monthly Settings for more details.
     */
    @JvmName("hmkbteaykqxkpahj")
    public suspend fun monthlySettings(`value`: Output<List<ContactsRotationRecurrenceMonthlySettingArgs>>) {
        this.monthlySettings = value
    }

    @JvmName("sgcgresvpqdclmkn")
    public suspend fun monthlySettings(vararg values: Output<ContactsRotationRecurrenceMonthlySettingArgs>) {
        this.monthlySettings = Output.all(values.asList())
    }

    /**
     * @param values (Optional) Information about on-call rotations that recur monthly. See Monthly Settings for more details.
     */
    @JvmName("xidxkbbkeiqtcqvp")
    public suspend fun monthlySettings(values: List<Output<ContactsRotationRecurrenceMonthlySettingArgs>>) {
        this.monthlySettings = Output.all(values)
    }

    /**
     * @param value (Required) The number of contacts, or shift team members designated to be on call concurrently during a shift.
     */
    @JvmName("suaoylcesowypcuv")
    public suspend fun numberOfOnCalls(`value`: Output<Int>) {
        this.numberOfOnCalls = value
    }

    /**
     * @param value (Required) The number of days, weeks, or months a single rotation lasts.
     */
    @JvmName("yedyxcdpcvwjuwxv")
    public suspend fun recurrenceMultiplier(`value`: Output<Int>) {
        this.recurrenceMultiplier = value
    }

    /**
     * @param value (Optional) Information about the days of the week that the on-call rotation coverage includes. See Shift Coverages for more details.
     */
    @JvmName("dsqegbktqgtiowsm")
    public suspend fun shiftCoverages(`value`: Output<List<ContactsRotationRecurrenceShiftCoverageArgs>>) {
        this.shiftCoverages = value
    }

    @JvmName("btnjlfwrsnmjnedk")
    public suspend fun shiftCoverages(vararg values: Output<ContactsRotationRecurrenceShiftCoverageArgs>) {
        this.shiftCoverages = Output.all(values.asList())
    }

    /**
     * @param values (Optional) Information about the days of the week that the on-call rotation coverage includes. See Shift Coverages for more details.
     */
    @JvmName("newwvnnvcpayyxfy")
    public suspend fun shiftCoverages(values: List<Output<ContactsRotationRecurrenceShiftCoverageArgs>>) {
        this.shiftCoverages = Output.all(values)
    }

    /**
     * @param value (Optional) Information about on-call rotations that recur weekly. See Weekly Settings for more details.
     */
    @JvmName("upobxmaljftpniuh")
    public suspend fun weeklySettings(`value`: Output<List<ContactsRotationRecurrenceWeeklySettingArgs>>) {
        this.weeklySettings = value
    }

    @JvmName("yowwsoocjcqthlcb")
    public suspend fun weeklySettings(vararg values: Output<ContactsRotationRecurrenceWeeklySettingArgs>) {
        this.weeklySettings = Output.all(values.asList())
    }

    /**
     * @param values (Optional) Information about on-call rotations that recur weekly. See Weekly Settings for more details.
     */
    @JvmName("eenbglecoahokqyx")
    public suspend fun weeklySettings(values: List<Output<ContactsRotationRecurrenceWeeklySettingArgs>>) {
        this.weeklySettings = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("kcxugftuurfrvvxm")
    public suspend fun dailySettings(`value`: List<ContactsRotationRecurrenceDailySettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dailySettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dyxfxbuxubvatvha")
    public suspend fun dailySettings(argument: List<suspend ContactsRotationRecurrenceDailySettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContactsRotationRecurrenceDailySettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dailySettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lrfyygeafvtqariq")
    public suspend fun dailySettings(vararg argument: suspend ContactsRotationRecurrenceDailySettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContactsRotationRecurrenceDailySettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dailySettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ytwmoxwsugmvyqcr")
    public suspend fun dailySettings(argument: suspend ContactsRotationRecurrenceDailySettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContactsRotationRecurrenceDailySettingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dailySettings = mapped
    }

    /**
     * @param values
     */
    @JvmName("xnsrgptvnkcktsce")
    public suspend fun dailySettings(vararg values: ContactsRotationRecurrenceDailySettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dailySettings = mapped
    }

    /**
     * @param value (Optional) Information about on-call rotations that recur monthly. See Monthly Settings for more details.
     */
    @JvmName("lmmoteerynefeprs")
    public suspend fun monthlySettings(`value`: List<ContactsRotationRecurrenceMonthlySettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monthlySettings = mapped
    }

    /**
     * @param argument (Optional) Information about on-call rotations that recur monthly. See Monthly Settings for more details.
     */
    @JvmName("rvhblruvxabnukgv")
    public suspend fun monthlySettings(argument: List<suspend ContactsRotationRecurrenceMonthlySettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContactsRotationRecurrenceMonthlySettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.monthlySettings = mapped
    }

    /**
     * @param argument (Optional) Information about on-call rotations that recur monthly. See Monthly Settings for more details.
     */
    @JvmName("koliphqqwsjmuorq")
    public suspend fun monthlySettings(vararg argument: suspend ContactsRotationRecurrenceMonthlySettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContactsRotationRecurrenceMonthlySettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.monthlySettings = mapped
    }

    /**
     * @param argument (Optional) Information about on-call rotations that recur monthly. See Monthly Settings for more details.
     */
    @JvmName("jaehmgiysduwwdwu")
    public suspend fun monthlySettings(argument: suspend ContactsRotationRecurrenceMonthlySettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContactsRotationRecurrenceMonthlySettingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.monthlySettings = mapped
    }

    /**
     * @param values (Optional) Information about on-call rotations that recur monthly. See Monthly Settings for more details.
     */
    @JvmName("ukrvxmditksjvhef")
    public suspend fun monthlySettings(vararg values: ContactsRotationRecurrenceMonthlySettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monthlySettings = mapped
    }

    /**
     * @param value (Required) The number of contacts, or shift team members designated to be on call concurrently during a shift.
     */
    @JvmName("dbjpbqrqgmlerliw")
    public suspend fun numberOfOnCalls(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.numberOfOnCalls = mapped
    }

    /**
     * @param value (Required) The number of days, weeks, or months a single rotation lasts.
     */
    @JvmName("wbyuchyutwmquskj")
    public suspend fun recurrenceMultiplier(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrenceMultiplier = mapped
    }

    /**
     * @param value (Optional) Information about the days of the week that the on-call rotation coverage includes. See Shift Coverages for more details.
     */
    @JvmName("qbwcwvdnkgbwrkke")
    public suspend fun shiftCoverages(`value`: List<ContactsRotationRecurrenceShiftCoverageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shiftCoverages = mapped
    }

    /**
     * @param argument (Optional) Information about the days of the week that the on-call rotation coverage includes. See Shift Coverages for more details.
     */
    @JvmName("ugxfggslprgriamp")
    public suspend fun shiftCoverages(argument: List<suspend ContactsRotationRecurrenceShiftCoverageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContactsRotationRecurrenceShiftCoverageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.shiftCoverages = mapped
    }

    /**
     * @param argument (Optional) Information about the days of the week that the on-call rotation coverage includes. See Shift Coverages for more details.
     */
    @JvmName("ypjmyctcgixrmnxx")
    public suspend fun shiftCoverages(vararg argument: suspend ContactsRotationRecurrenceShiftCoverageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContactsRotationRecurrenceShiftCoverageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.shiftCoverages = mapped
    }

    /**
     * @param argument (Optional) Information about the days of the week that the on-call rotation coverage includes. See Shift Coverages for more details.
     */
    @JvmName("gojtvfijwrkierdb")
    public suspend fun shiftCoverages(argument: suspend ContactsRotationRecurrenceShiftCoverageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContactsRotationRecurrenceShiftCoverageArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.shiftCoverages = mapped
    }

    /**
     * @param values (Optional) Information about the days of the week that the on-call rotation coverage includes. See Shift Coverages for more details.
     */
    @JvmName("mlckfcsxnyjopuqn")
    public suspend fun shiftCoverages(vararg values: ContactsRotationRecurrenceShiftCoverageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shiftCoverages = mapped
    }

    /**
     * @param value (Optional) Information about on-call rotations that recur weekly. See Weekly Settings for more details.
     */
    @JvmName("vvgaffwxguuxxpjh")
    public suspend fun weeklySettings(`value`: List<ContactsRotationRecurrenceWeeklySettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklySettings = mapped
    }

    /**
     * @param argument (Optional) Information about on-call rotations that recur weekly. See Weekly Settings for more details.
     */
    @JvmName("xhvgrdfborwdhtim")
    public suspend fun weeklySettings(argument: List<suspend ContactsRotationRecurrenceWeeklySettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContactsRotationRecurrenceWeeklySettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.weeklySettings = mapped
    }

    /**
     * @param argument (Optional) Information about on-call rotations that recur weekly. See Weekly Settings for more details.
     */
    @JvmName("rfpnlwnwcskxvybp")
    public suspend fun weeklySettings(vararg argument: suspend ContactsRotationRecurrenceWeeklySettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContactsRotationRecurrenceWeeklySettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.weeklySettings = mapped
    }

    /**
     * @param argument (Optional) Information about on-call rotations that recur weekly. See Weekly Settings for more details.
     */
    @JvmName("efpvlheuepkdsoev")
    public suspend fun weeklySettings(argument: suspend ContactsRotationRecurrenceWeeklySettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContactsRotationRecurrenceWeeklySettingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.weeklySettings = mapped
    }

    /**
     * @param values (Optional) Information about on-call rotations that recur weekly. See Weekly Settings for more details.
     */
    @JvmName("ltutjssbnbjdvqhq")
    public suspend fun weeklySettings(vararg values: ContactsRotationRecurrenceWeeklySettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weeklySettings = mapped
    }

    internal fun build(): ContactsRotationRecurrenceArgs = ContactsRotationRecurrenceArgs(
        dailySettings = dailySettings,
        monthlySettings = monthlySettings,
        numberOfOnCalls = numberOfOnCalls ?: throw PulumiNullFieldException("numberOfOnCalls"),
        recurrenceMultiplier = recurrenceMultiplier ?: throw
            PulumiNullFieldException("recurrenceMultiplier"),
        shiftCoverages = shiftCoverages,
        weeklySettings = weeklySettings,
    )
}
