@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceDailySettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hourOfDay (Required) The hour of the day.
 * @property minuteOfHour (Required) The minutes of the hour.
 */
public data class ContactsRotationRecurrenceDailySettingArgs(
    public val hourOfDay: Output<Int>,
    public val minuteOfHour: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceDailySettingArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceDailySettingArgs =
        com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceDailySettingArgs.builder()
            .hourOfDay(hourOfDay.applyValue({ args0 -> args0 }))
            .minuteOfHour(minuteOfHour.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactsRotationRecurrenceDailySettingArgs].
 */
@PulumiTagMarker
public class ContactsRotationRecurrenceDailySettingArgsBuilder internal constructor() {
    private var hourOfDay: Output<Int>? = null

    private var minuteOfHour: Output<Int>? = null

    /**
     * @param value (Required) The hour of the day.
     */
    @JvmName("mckigodbaphjxikk")
    public suspend fun hourOfDay(`value`: Output<Int>) {
        this.hourOfDay = value
    }

    /**
     * @param value (Required) The minutes of the hour.
     */
    @JvmName("dasetsufjkqryjhf")
    public suspend fun minuteOfHour(`value`: Output<Int>) {
        this.minuteOfHour = value
    }

    /**
     * @param value (Required) The hour of the day.
     */
    @JvmName("anhwgwxtqjhvmqkr")
    public suspend fun hourOfDay(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hourOfDay = mapped
    }

    /**
     * @param value (Required) The minutes of the hour.
     */
    @JvmName("cqtvsyrlkaaepbvm")
    public suspend fun minuteOfHour(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minuteOfHour = mapped
    }

    internal fun build(): ContactsRotationRecurrenceDailySettingArgs =
        ContactsRotationRecurrenceDailySettingArgs(
            hourOfDay = hourOfDay ?: throw PulumiNullFieldException("hourOfDay"),
            minuteOfHour = minuteOfHour ?: throw PulumiNullFieldException("minuteOfHour"),
        )
}
