@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceMonthlySettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property dayOfMonth (Required) The day of the month when monthly recurring on-call rotations begin.
 * @property handOffTime (Required) The hand off time. See Hand Off Time for more details.
 */
public data class ContactsRotationRecurrenceMonthlySettingArgs(
    public val dayOfMonth: Output<Int>,
    public val handOffTime: Output<ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceMonthlySettingArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceMonthlySettingArgs =
        com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceMonthlySettingArgs.builder()
            .dayOfMonth(dayOfMonth.applyValue({ args0 -> args0 }))
            .handOffTime(handOffTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ContactsRotationRecurrenceMonthlySettingArgs].
 */
@PulumiTagMarker
public class ContactsRotationRecurrenceMonthlySettingArgsBuilder internal constructor() {
    private var dayOfMonth: Output<Int>? = null

    private var handOffTime: Output<ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs>? = null

    /**
     * @param value (Required) The day of the month when monthly recurring on-call rotations begin.
     */
    @JvmName("gfpixyteiueuebbx")
    public suspend fun dayOfMonth(`value`: Output<Int>) {
        this.dayOfMonth = value
    }

    /**
     * @param value (Required) The hand off time. See Hand Off Time for more details.
     */
    @JvmName("vqjxdvehfirgildv")
    public suspend fun handOffTime(`value`: Output<ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs>) {
        this.handOffTime = value
    }

    /**
     * @param value (Required) The day of the month when monthly recurring on-call rotations begin.
     */
    @JvmName("vimrrugmkdslpfoy")
    public suspend fun dayOfMonth(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dayOfMonth = mapped
    }

    /**
     * @param value (Required) The hand off time. See Hand Off Time for more details.
     */
    @JvmName("eewauthidwrbqdew")
    public suspend fun handOffTime(`value`: ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.handOffTime = mapped
    }

    /**
     * @param argument (Required) The hand off time. See Hand Off Time for more details.
     */
    @JvmName("lqybmdckpqwubose")
    public suspend fun handOffTime(argument: suspend ContactsRotationRecurrenceMonthlySettingHandOffTimeArgsBuilder.() -> Unit) {
        val toBeMapped = ContactsRotationRecurrenceMonthlySettingHandOffTimeArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.handOffTime = mapped
    }

    internal fun build(): ContactsRotationRecurrenceMonthlySettingArgs =
        ContactsRotationRecurrenceMonthlySettingArgs(
            dayOfMonth = dayOfMonth ?: throw PulumiNullFieldException("dayOfMonth"),
            handOffTime = handOffTime,
        )
}
