@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hourOfDay (Required) The hour of the day.
 * @property minuteOfHour (Required) The minutes of the hour.
 */
public data class ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs(
    public val hourOfDay: Output<Int>,
    public val minuteOfHour: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs =
        com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs.builder()
            .hourOfDay(hourOfDay.applyValue({ args0 -> args0 }))
            .minuteOfHour(minuteOfHour.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs].
 */
@PulumiTagMarker
public class ContactsRotationRecurrenceMonthlySettingHandOffTimeArgsBuilder internal constructor() {
    private var hourOfDay: Output<Int>? = null

    private var minuteOfHour: Output<Int>? = null

    /**
     * @param value (Required) The hour of the day.
     */
    @JvmName("qbjyanmokmpnuwoy")
    public suspend fun hourOfDay(`value`: Output<Int>) {
        this.hourOfDay = value
    }

    /**
     * @param value (Required) The minutes of the hour.
     */
    @JvmName("qaqlkbfhipavqxdw")
    public suspend fun minuteOfHour(`value`: Output<Int>) {
        this.minuteOfHour = value
    }

    /**
     * @param value (Required) The hour of the day.
     */
    @JvmName("sscfnrcdinyfneuo")
    public suspend fun hourOfDay(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hourOfDay = mapped
    }

    /**
     * @param value (Required) The minutes of the hour.
     */
    @JvmName("oevhfgahhdvrglnt")
    public suspend fun minuteOfHour(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minuteOfHour = mapped
    }

    internal fun build(): ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs =
        ContactsRotationRecurrenceMonthlySettingHandOffTimeArgs(
            hourOfDay = hourOfDay ?: throw PulumiNullFieldException("hourOfDay"),
            minuteOfHour = minuteOfHour ?: throw PulumiNullFieldException("minuteOfHour"),
        )
}
