@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceShiftCoverageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property coverageTimes (Required) Information about when an on-call shift begins and ends. See Coverage Times for more details.
 * @property mapBlockKey
 */
public data class ContactsRotationRecurrenceShiftCoverageArgs(
    public val coverageTimes: Output<List<ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs>>? =
        null,
    public val mapBlockKey: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceShiftCoverageArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceShiftCoverageArgs =
        com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceShiftCoverageArgs.builder()
            .coverageTimes(
                coverageTimes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .mapBlockKey(mapBlockKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactsRotationRecurrenceShiftCoverageArgs].
 */
@PulumiTagMarker
public class ContactsRotationRecurrenceShiftCoverageArgsBuilder internal constructor() {
    private var coverageTimes: Output<List<ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs>>? =
        null

    private var mapBlockKey: Output<String>? = null

    /**
     * @param value (Required) Information about when an on-call shift begins and ends. See Coverage Times for more details.
     */
    @JvmName("tybswejwtlnuyddg")
    public suspend fun coverageTimes(`value`: Output<List<ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs>>) {
        this.coverageTimes = value
    }

    @JvmName("lsyqlbpxasssamyq")
    public suspend fun coverageTimes(vararg values: Output<ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs>) {
        this.coverageTimes = Output.all(values.asList())
    }

    /**
     * @param values (Required) Information about when an on-call shift begins and ends. See Coverage Times for more details.
     */
    @JvmName("uwfosljpxdafgorn")
    public suspend fun coverageTimes(values: List<Output<ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs>>) {
        this.coverageTimes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("svpsttngmcqidtlc")
    public suspend fun mapBlockKey(`value`: Output<String>) {
        this.mapBlockKey = value
    }

    /**
     * @param value (Required) Information about when an on-call shift begins and ends. See Coverage Times for more details.
     */
    @JvmName("sddktlsjspckgahc")
    public suspend fun coverageTimes(`value`: List<ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coverageTimes = mapped
    }

    /**
     * @param argument (Required) Information about when an on-call shift begins and ends. See Coverage Times for more details.
     */
    @JvmName("pfsuktncwdoubroc")
    public suspend fun coverageTimes(argument: List<suspend ContactsRotationRecurrenceShiftCoverageCoverageTimeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContactsRotationRecurrenceShiftCoverageCoverageTimeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.coverageTimes = mapped
    }

    /**
     * @param argument (Required) Information about when an on-call shift begins and ends. See Coverage Times for more details.
     */
    @JvmName("yqdscodmdjyepnsn")
    public suspend fun coverageTimes(vararg argument: suspend ContactsRotationRecurrenceShiftCoverageCoverageTimeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContactsRotationRecurrenceShiftCoverageCoverageTimeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.coverageTimes = mapped
    }

    /**
     * @param argument (Required) Information about when an on-call shift begins and ends. See Coverage Times for more details.
     */
    @JvmName("ilxwgapuqkyoflkr")
    public suspend fun coverageTimes(argument: suspend ContactsRotationRecurrenceShiftCoverageCoverageTimeArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ContactsRotationRecurrenceShiftCoverageCoverageTimeArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.coverageTimes = mapped
    }

    /**
     * @param values (Required) Information about when an on-call shift begins and ends. See Coverage Times for more details.
     */
    @JvmName("wkwsnqwgvejqepuv")
    public suspend fun coverageTimes(vararg values: ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.coverageTimes = mapped
    }

    /**
     * @param value
     */
    @JvmName("plerdvyfniqwskkf")
    public suspend fun mapBlockKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mapBlockKey = mapped
    }

    internal fun build(): ContactsRotationRecurrenceShiftCoverageArgs =
        ContactsRotationRecurrenceShiftCoverageArgs(
            coverageTimes = coverageTimes,
            mapBlockKey = mapBlockKey ?: throw PulumiNullFieldException("mapBlockKey"),
        )
}
