@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property end (Required) The end time of the on-call shift. See Hand Off Time for more details.
 * @property start (Required) The start time of the on-call shift. See Hand Off Time for more details.
 */
public data class ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs(
    public val end: Output<ContactsRotationRecurrenceShiftCoverageCoverageTimeEndArgs>? = null,
    public val start: Output<ContactsRotationRecurrenceShiftCoverageCoverageTimeStartArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs =
        com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs.builder()
            .end(end?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .start(start?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs].
 */
@PulumiTagMarker
public class ContactsRotationRecurrenceShiftCoverageCoverageTimeArgsBuilder internal constructor() {
    private var end: Output<ContactsRotationRecurrenceShiftCoverageCoverageTimeEndArgs>? = null

    private var start: Output<ContactsRotationRecurrenceShiftCoverageCoverageTimeStartArgs>? = null

    /**
     * @param value (Required) The end time of the on-call shift. See Hand Off Time for more details.
     */
    @JvmName("hxliqasgtytiyods")
    public suspend fun end(`value`: Output<ContactsRotationRecurrenceShiftCoverageCoverageTimeEndArgs>) {
        this.end = value
    }

    /**
     * @param value (Required) The start time of the on-call shift. See Hand Off Time for more details.
     */
    @JvmName("msyutlovoxdrtext")
    public suspend fun start(`value`: Output<ContactsRotationRecurrenceShiftCoverageCoverageTimeStartArgs>) {
        this.start = value
    }

    /**
     * @param value (Required) The end time of the on-call shift. See Hand Off Time for more details.
     */
    @JvmName("yvqutoojcwvfvtjl")
    public suspend fun end(`value`: ContactsRotationRecurrenceShiftCoverageCoverageTimeEndArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.end = mapped
    }

    /**
     * @param argument (Required) The end time of the on-call shift. See Hand Off Time for more details.
     */
    @JvmName("beqhuqedrlvyssng")
    public suspend fun end(argument: suspend ContactsRotationRecurrenceShiftCoverageCoverageTimeEndArgsBuilder.() -> Unit) {
        val toBeMapped =
            ContactsRotationRecurrenceShiftCoverageCoverageTimeEndArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.end = mapped
    }

    /**
     * @param value (Required) The start time of the on-call shift. See Hand Off Time for more details.
     */
    @JvmName("mqklmfxchlwqbink")
    public suspend fun start(`value`: ContactsRotationRecurrenceShiftCoverageCoverageTimeStartArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.start = mapped
    }

    /**
     * @param argument (Required) The start time of the on-call shift. See Hand Off Time for more details.
     */
    @JvmName("yqutgxjqrfoylgvt")
    public suspend fun start(argument: suspend ContactsRotationRecurrenceShiftCoverageCoverageTimeStartArgsBuilder.() -> Unit) {
        val toBeMapped =
            ContactsRotationRecurrenceShiftCoverageCoverageTimeStartArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.start = mapped
    }

    internal fun build(): ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs =
        ContactsRotationRecurrenceShiftCoverageCoverageTimeArgs(
            end = end,
            start = start,
        )
}
