@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceWeeklySettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property dayOfWeek (Required) The day of the week when the shift coverage occurs.
 * @property handOffTime (Required) The hand off time. See Hand Off Time for more details.
 */
public data class ContactsRotationRecurrenceWeeklySettingArgs(
    public val dayOfWeek: Output<String>,
    public val handOffTime: Output<ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceWeeklySettingArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceWeeklySettingArgs =
        com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceWeeklySettingArgs.builder()
            .dayOfWeek(dayOfWeek.applyValue({ args0 -> args0 }))
            .handOffTime(handOffTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ContactsRotationRecurrenceWeeklySettingArgs].
 */
@PulumiTagMarker
public class ContactsRotationRecurrenceWeeklySettingArgsBuilder internal constructor() {
    private var dayOfWeek: Output<String>? = null

    private var handOffTime: Output<ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs>? = null

    /**
     * @param value (Required) The day of the week when the shift coverage occurs.
     */
    @JvmName("pjvkiicppjdymvmq")
    public suspend fun dayOfWeek(`value`: Output<String>) {
        this.dayOfWeek = value
    }

    /**
     * @param value (Required) The hand off time. See Hand Off Time for more details.
     */
    @JvmName("unktmdvdsudwdvjb")
    public suspend fun handOffTime(`value`: Output<ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs>) {
        this.handOffTime = value
    }

    /**
     * @param value (Required) The day of the week when the shift coverage occurs.
     */
    @JvmName("ncyodxyjyovlbvad")
    public suspend fun dayOfWeek(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dayOfWeek = mapped
    }

    /**
     * @param value (Required) The hand off time. See Hand Off Time for more details.
     */
    @JvmName("oyjmtomdxqianodi")
    public suspend fun handOffTime(`value`: ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.handOffTime = mapped
    }

    /**
     * @param argument (Required) The hand off time. See Hand Off Time for more details.
     */
    @JvmName("kdvnmqnphdqqddsr")
    public suspend fun handOffTime(argument: suspend ContactsRotationRecurrenceWeeklySettingHandOffTimeArgsBuilder.() -> Unit) {
        val toBeMapped = ContactsRotationRecurrenceWeeklySettingHandOffTimeArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.handOffTime = mapped
    }

    internal fun build(): ContactsRotationRecurrenceWeeklySettingArgs =
        ContactsRotationRecurrenceWeeklySettingArgs(
            dayOfWeek = dayOfWeek ?: throw PulumiNullFieldException("dayOfWeek"),
            handOffTime = handOffTime,
        )
}
