@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hourOfDay (Required) The hour of the day.
 * @property minuteOfHour (Required) The minutes of the hour.
 */
public data class ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs(
    public val hourOfDay: Output<Int>,
    public val minuteOfHour: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs =
        com.pulumi.aws.ssm.inputs.ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs.builder()
            .hourOfDay(hourOfDay.applyValue({ args0 -> args0 }))
            .minuteOfHour(minuteOfHour.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs].
 */
@PulumiTagMarker
public class ContactsRotationRecurrenceWeeklySettingHandOffTimeArgsBuilder internal constructor() {
    private var hourOfDay: Output<Int>? = null

    private var minuteOfHour: Output<Int>? = null

    /**
     * @param value (Required) The hour of the day.
     */
    @JvmName("isikennfvtcbmilw")
    public suspend fun hourOfDay(`value`: Output<Int>) {
        this.hourOfDay = value
    }

    /**
     * @param value (Required) The minutes of the hour.
     */
    @JvmName("bseblwyhsubumfxb")
    public suspend fun minuteOfHour(`value`: Output<Int>) {
        this.minuteOfHour = value
    }

    /**
     * @param value (Required) The hour of the day.
     */
    @JvmName("fbkesglnotoenrwh")
    public suspend fun hourOfDay(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hourOfDay = mapped
    }

    /**
     * @param value (Required) The minutes of the hour.
     */
    @JvmName("flghvctjtavihkgw")
    public suspend fun minuteOfHour(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minuteOfHour = mapped
    }

    internal fun build(): ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs =
        ContactsRotationRecurrenceWeeklySettingHandOffTimeArgs(
            hourOfDay = hourOfDay ?: throw PulumiNullFieldException("hourOfDay"),
            minuteOfHour = minuteOfHour ?: throw PulumiNullFieldException("minuteOfHour"),
        )
}
