@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.DocumentAttachmentsSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key The key of a key-value pair that identifies the location of an attachment to the document. Valid values: `SourceUrl`, `S3FileUrl`, `AttachmentReference`.
 * @property name The name of the document attachment file.
 * @property values The value of a key-value pair that identifies the location of an attachment to the document. The argument format is a list of a single string that depends on the type of key you specify - see the [API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_AttachmentsSource.html) for details.
 */
public data class DocumentAttachmentsSourceArgs(
    public val key: Output<String>,
    public val name: Output<String>? = null,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.DocumentAttachmentsSourceArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.DocumentAttachmentsSourceArgs =
        com.pulumi.aws.ssm.inputs.DocumentAttachmentsSourceArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DocumentAttachmentsSourceArgs].
 */
@PulumiTagMarker
public class DocumentAttachmentsSourceArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var name: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value The key of a key-value pair that identifies the location of an attachment to the document. Valid values: `SourceUrl`, `S3FileUrl`, `AttachmentReference`.
     */
    @JvmName("neclkpjddsnivopv")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The name of the document attachment file.
     */
    @JvmName("gbcydcsjojavqrmg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of a key-value pair that identifies the location of an attachment to the document. The argument format is a list of a single string that depends on the type of key you specify - see the [API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_AttachmentsSource.html) for details.
     */
    @JvmName("gktalnpioljvlbmv")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("cxcutcjmvmwolwxe")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The value of a key-value pair that identifies the location of an attachment to the document. The argument format is a list of a single string that depends on the type of key you specify - see the [API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_AttachmentsSource.html) for details.
     */
    @JvmName("dmrrbfrefsimnjew")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The key of a key-value pair that identifies the location of an attachment to the document. Valid values: `SourceUrl`, `S3FileUrl`, `AttachmentReference`.
     */
    @JvmName("asucrvshkkcssefu")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The name of the document attachment file.
     */
    @JvmName("kuicybvltlktfany")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of a key-value pair that identifies the location of an attachment to the document. The argument format is a list of a single string that depends on the type of key you specify - see the [API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_AttachmentsSource.html) for details.
     */
    @JvmName("epolqnthntoopecb")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values The value of a key-value pair that identifies the location of an attachment to the document. The argument format is a list of a single string that depends on the type of key you specify - see the [API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_AttachmentsSource.html) for details.
     */
    @JvmName("rfoouqxfpehxabry")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): DocumentAttachmentsSourceArgs = DocumentAttachmentsSourceArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        name = name,
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
