@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.GetContactsRotationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getContactsRotation.
 * @property arn The Amazon Resource Name (ARN) of the rotation.
 */
public data class GetContactsRotationPlainArgs(
    public val arn: String,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.GetContactsRotationPlainArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.GetContactsRotationPlainArgs =
        com.pulumi.aws.ssm.inputs.GetContactsRotationPlainArgs.builder()
            .arn(arn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContactsRotationPlainArgs].
 */
@PulumiTagMarker
public class GetContactsRotationPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the rotation.
     */
    @JvmName("mcqmgbcmraotrtht")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    internal fun build(): GetContactsRotationPlainArgs = GetContactsRotationPlainArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
    )
}
