@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.GetInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstances.
 * @property filters Configuration block(s) for filtering. Detailed below.
 */
public data class GetInstancesPlainArgs(
    public val filters: List<GetInstancesFilter>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.GetInstancesPlainArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.GetInstancesPlainArgs =
        com.pulumi.aws.ssm.inputs.GetInstancesPlainArgs.builder()
            .filters(
                filters?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetInstancesPlainArgsBuilder internal constructor() {
    private var filters: List<GetInstancesFilter>? = null

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("pdmbogaajefllaok")
    public suspend fun filters(`value`: List<GetInstancesFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("qalqxouflvixwsty")
    public suspend fun filters(argument: List<suspend GetInstancesFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetInstancesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("ttgpepjocqykusvw")
    public suspend fun filters(vararg argument: suspend GetInstancesFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetInstancesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("lfgwjuddaefjpyjr")
    public suspend fun filters(argument: suspend GetInstancesFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetInstancesFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("udicrjpycmgsbcsl")
    public suspend fun filters(vararg values: GetInstancesFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    internal fun build(): GetInstancesPlainArgs = GetInstancesPlainArgs(
        filters = filters,
    )
}
