@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.GetParametersByPathPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getParametersByPath.
 * @property path The hierarchy for the parameter. Hierarchies start with a forward slash (/). The hierarchy is the parameter name except the last part of the parameter. The last part of the parameter name can't be in the path. A parameter name hierarchy can have a maximum of 15 levels. **Note:** If the parameter name (e.g., `/my-app/my-param`) is specified, the data source will not retrieve any value as designed, unless there are other parameters that happen to use the former path in their hierarchy (e.g., `/my-app/my-param/my-actual-param`).
 * @property recursive Whether to retrieve all parameters within the hirerachy. Defaults to `false`.
 * @property withDecryption Whether to retrieve all parameters in the hierarchy, particularly those of `SecureString` type, with their value decrypted. Defaults to `true`.
 */
public data class GetParametersByPathPlainArgs(
    public val path: String,
    public val recursive: Boolean? = null,
    public val withDecryption: Boolean? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.GetParametersByPathPlainArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.GetParametersByPathPlainArgs =
        com.pulumi.aws.ssm.inputs.GetParametersByPathPlainArgs.builder()
            .path(path.let({ args0 -> args0 }))
            .recursive(recursive?.let({ args0 -> args0 }))
            .withDecryption(withDecryption?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetParametersByPathPlainArgs].
 */
@PulumiTagMarker
public class GetParametersByPathPlainArgsBuilder internal constructor() {
    private var path: String? = null

    private var recursive: Boolean? = null

    private var withDecryption: Boolean? = null

    /**
     * @param value The hierarchy for the parameter. Hierarchies start with a forward slash (/). The hierarchy is the parameter name except the last part of the parameter. The last part of the parameter name can't be in the path. A parameter name hierarchy can have a maximum of 15 levels. **Note:** If the parameter name (e.g., `/my-app/my-param`) is specified, the data source will not retrieve any value as designed, unless there are other parameters that happen to use the former path in their hierarchy (e.g., `/my-app/my-param/my-actual-param`).
     */
    @JvmName("tcrstswibedxgmxl")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.path = mapped
    }

    /**
     * @param value Whether to retrieve all parameters within the hirerachy. Defaults to `false`.
     */
    @JvmName("kcqavlxddkbuefte")
    public suspend fun recursive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.recursive = mapped
    }

    /**
     * @param value Whether to retrieve all parameters in the hierarchy, particularly those of `SecureString` type, with their value decrypted. Defaults to `true`.
     */
    @JvmName("wvamivrumsirtvky")
    public suspend fun withDecryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.withDecryption = mapped
    }

    internal fun build(): GetParametersByPathPlainArgs = GetParametersByPathPlainArgs(
        path = path ?: throw PulumiNullFieldException("path"),
        recursive = recursive,
        withDecryption = withDecryption,
    )
}
