@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property documentVersion The version of an Automation document to use during task execution.
 * @property parameters The parameters for the RUN_COMMAND task execution. Documented below.
 */
public data class MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs(
    public val documentVersion: Output<String>? = null,
    public val parameters: Output<List<MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs =
        com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs.builder()
            .documentVersion(documentVersion?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs].
 */
@PulumiTagMarker
public class MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgsBuilder internal constructor() {
    private var documentVersion: Output<String>? = null

    private var parameters:
        Output<List<MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs>>? =
        null

    /**
     * @param value The version of an Automation document to use during task execution.
     */
    @JvmName("fisiavvpufwtiukd")
    public suspend fun documentVersion(`value`: Output<String>) {
        this.documentVersion = value
    }

    /**
     * @param value The parameters for the RUN_COMMAND task execution. Documented below.
     */
    @JvmName("prdnsxocuoteeoue")
    public suspend fun parameters(`value`: Output<List<MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("hlwsdkxgykfneipp")
    public suspend fun parameters(vararg values: Output<MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters for the RUN_COMMAND task execution. Documented below.
     */
    @JvmName("wnpeytidfxbfxmva")
    public suspend fun parameters(values: List<Output<MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The version of an Automation document to use during task execution.
     */
    @JvmName("ndyikiawselixplr")
    public suspend fun documentVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentVersion = mapped
    }

    /**
     * @param value The parameters for the RUN_COMMAND task execution. Documented below.
     */
    @JvmName("ywqtxhiabixfiwwy")
    public suspend fun parameters(`value`: List<MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters for the RUN_COMMAND task execution. Documented below.
     */
    @JvmName("gmiycskkkbdxynqi")
    public suspend fun parameters(argument: List<suspend MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters for the RUN_COMMAND task execution. Documented below.
     */
    @JvmName("kqthpmaalkmficqv")
    public suspend fun parameters(vararg argument: suspend MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters for the RUN_COMMAND task execution. Documented below.
     */
    @JvmName("uresleqpywdbpywd")
    public suspend fun parameters(argument: suspend MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameters for the RUN_COMMAND task execution. Documented below.
     */
    @JvmName("idvdrvprcmgqococ")
    public suspend fun parameters(vararg values: MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    internal fun build(): MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs =
        MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs(
            documentVersion = documentVersion,
            parameters = parameters,
        )
}
