@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clientContext Pass client-specific information to the Lambda function that you are invoking.
 * @property payload JSON to provide to your Lambda function as input.
 * @property qualifier Specify a Lambda function version or alias name.
 */
public data class MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs(
    public val clientContext: Output<String>? = null,
    public val payload: Output<String>? = null,
    public val qualifier: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs =
        com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs.builder()
            .clientContext(clientContext?.applyValue({ args0 -> args0 }))
            .payload(payload?.applyValue({ args0 -> args0 }))
            .qualifier(qualifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs].
 */
@PulumiTagMarker
public class MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgsBuilder internal constructor() {
    private var clientContext: Output<String>? = null

    private var payload: Output<String>? = null

    private var qualifier: Output<String>? = null

    /**
     * @param value Pass client-specific information to the Lambda function that you are invoking.
     */
    @JvmName("afddepjrpukdyjxf")
    public suspend fun clientContext(`value`: Output<String>) {
        this.clientContext = value
    }

    /**
     * @param value JSON to provide to your Lambda function as input.
     */
    @JvmName("uspgooffufgmajbd")
    public suspend fun payload(`value`: Output<String>) {
        this.payload = value
    }

    /**
     * @param value Specify a Lambda function version or alias name.
     */
    @JvmName("xtdwaqqmqilqcjqn")
    public suspend fun qualifier(`value`: Output<String>) {
        this.qualifier = value
    }

    /**
     * @param value Pass client-specific information to the Lambda function that you are invoking.
     */
    @JvmName("mojtsxttytulpjns")
    public suspend fun clientContext(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientContext = mapped
    }

    /**
     * @param value JSON to provide to your Lambda function as input.
     */
    @JvmName("upypujxwelirpiet")
    public suspend fun payload(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payload = mapped
    }

    /**
     * @param value Specify a Lambda function version or alias name.
     */
    @JvmName("xriykevnkawpjxsv")
    public suspend fun qualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qualifier = mapped
    }

    internal fun build(): MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs =
        MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs(
            clientContext = clientContext,
            payload = payload,
            qualifier = qualifier,
        )
}
