@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchConfig Configuration options for sending command output to CloudWatch Logs. Documented below.
 * @property comment Information about the command(s) to execute.
 * @property documentHash The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes have been deprecated.
 * @property documentHashType SHA-256 or SHA-1. SHA-1 hashes have been deprecated. Valid values: `Sha256` and `Sha1`
 * @property documentVersion The version of an Automation document to use during task execution.
 * @property notificationConfig Configurations for sending notifications about command status changes on a per-instance basis. Documented below.
 * @property outputS3Bucket The name of the Amazon S3 bucket.
 * @property outputS3KeyPrefix The Amazon S3 bucket subfolder.
 * @property parameters The parameters for the RUN_COMMAND task execution. Documented below.
 * @property serviceRoleArn The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.
 * @property timeoutSeconds If this time is reached and the command has not already started executing, it doesn't run.
 */
public data class MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs(
    public val cloudwatchConfig: Output<MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfigArgs>? =
        null,
    public val comment: Output<String>? = null,
    public val documentHash: Output<String>? = null,
    public val documentHashType: Output<String>? = null,
    public val documentVersion: Output<String>? = null,
    public val notificationConfig: Output<MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs>? =
        null,
    public val outputS3Bucket: Output<String>? = null,
    public val outputS3KeyPrefix: Output<String>? = null,
    public val parameters: Output<List<MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs>>? =
        null,
    public val serviceRoleArn: Output<String>? = null,
    public val timeoutSeconds: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs =
        com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs.builder()
            .cloudwatchConfig(cloudwatchConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .comment(comment?.applyValue({ args0 -> args0 }))
            .documentHash(documentHash?.applyValue({ args0 -> args0 }))
            .documentHashType(documentHashType?.applyValue({ args0 -> args0 }))
            .documentVersion(documentVersion?.applyValue({ args0 -> args0 }))
            .notificationConfig(
                notificationConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .outputS3Bucket(outputS3Bucket?.applyValue({ args0 -> args0 }))
            .outputS3KeyPrefix(outputS3KeyPrefix?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .serviceRoleArn(serviceRoleArn?.applyValue({ args0 -> args0 }))
            .timeoutSeconds(timeoutSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs].
 */
@PulumiTagMarker
public class MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgsBuilder internal constructor() {
    private var cloudwatchConfig:
        Output<MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfigArgs>? =
        null

    private var comment: Output<String>? = null

    private var documentHash: Output<String>? = null

    private var documentHashType: Output<String>? = null

    private var documentVersion: Output<String>? = null

    private var notificationConfig:
        Output<MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs>? =
        null

    private var outputS3Bucket: Output<String>? = null

    private var outputS3KeyPrefix: Output<String>? = null

    private var parameters:
        Output<List<MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs>>? =
        null

    private var serviceRoleArn: Output<String>? = null

    private var timeoutSeconds: Output<Int>? = null

    /**
     * @param value Configuration options for sending command output to CloudWatch Logs. Documented below.
     */
    @JvmName("bcwgwxrvdlgxquyj")
    public suspend fun cloudwatchConfig(`value`: Output<MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfigArgs>) {
        this.cloudwatchConfig = value
    }

    /**
     * @param value Information about the command(s) to execute.
     */
    @JvmName("tncblooajdfxsvmo")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes have been deprecated.
     */
    @JvmName("pscobldiommmhovj")
    public suspend fun documentHash(`value`: Output<String>) {
        this.documentHash = value
    }

    /**
     * @param value SHA-256 or SHA-1. SHA-1 hashes have been deprecated. Valid values: `Sha256` and `Sha1`
     */
    @JvmName("elflxedmylqlrnpq")
    public suspend fun documentHashType(`value`: Output<String>) {
        this.documentHashType = value
    }

    /**
     * @param value The version of an Automation document to use during task execution.
     */
    @JvmName("dguojkcqortytlit")
    public suspend fun documentVersion(`value`: Output<String>) {
        this.documentVersion = value
    }

    /**
     * @param value Configurations for sending notifications about command status changes on a per-instance basis. Documented below.
     */
    @JvmName("qfheerpskobhnlrp")
    public suspend fun notificationConfig(`value`: Output<MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs>) {
        this.notificationConfig = value
    }

    /**
     * @param value The name of the Amazon S3 bucket.
     */
    @JvmName("ofyavdyfurhpirmm")
    public suspend fun outputS3Bucket(`value`: Output<String>) {
        this.outputS3Bucket = value
    }

    /**
     * @param value The Amazon S3 bucket subfolder.
     */
    @JvmName("obcfwlntnvueuekj")
    public suspend fun outputS3KeyPrefix(`value`: Output<String>) {
        this.outputS3KeyPrefix = value
    }

    /**
     * @param value The parameters for the RUN_COMMAND task execution. Documented below.
     */
    @JvmName("gickutaqguvqyfcx")
    public suspend fun parameters(`value`: Output<List<MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("besvaqrxplexfjij")
    public suspend fun parameters(vararg values: Output<MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters for the RUN_COMMAND task execution. Documented below.
     */
    @JvmName("kwhedybvvhjssdho")
    public suspend fun parameters(values: List<Output<MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.
     */
    @JvmName("vngnnojbikhqumae")
    public suspend fun serviceRoleArn(`value`: Output<String>) {
        this.serviceRoleArn = value
    }

    /**
     * @param value If this time is reached and the command has not already started executing, it doesn't run.
     */
    @JvmName("qkglgmajnwmmlxfp")
    public suspend fun timeoutSeconds(`value`: Output<Int>) {
        this.timeoutSeconds = value
    }

    /**
     * @param value Configuration options for sending command output to CloudWatch Logs. Documented below.
     */
    @JvmName("tlooainblctrhhak")
    public suspend fun cloudwatchConfig(`value`: MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchConfig = mapped
    }

    /**
     * @param argument Configuration options for sending command output to CloudWatch Logs. Documented below.
     */
    @JvmName("gjtjbyxjdbngilve")
    public suspend fun cloudwatchConfig(argument: suspend MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchConfig = mapped
    }

    /**
     * @param value Information about the command(s) to execute.
     */
    @JvmName("qsgnluputttgbimp")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes have been deprecated.
     */
    @JvmName("wdfntkvrhofqjybr")
    public suspend fun documentHash(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentHash = mapped
    }

    /**
     * @param value SHA-256 or SHA-1. SHA-1 hashes have been deprecated. Valid values: `Sha256` and `Sha1`
     */
    @JvmName("ukxusgjauyrsfccj")
    public suspend fun documentHashType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentHashType = mapped
    }

    /**
     * @param value The version of an Automation document to use during task execution.
     */
    @JvmName("ytploeyomnbdvcsj")
    public suspend fun documentVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentVersion = mapped
    }

    /**
     * @param value Configurations for sending notifications about command status changes on a per-instance basis. Documented below.
     */
    @JvmName("uoqsnndcxkjksbui")
    public suspend fun notificationConfig(`value`: MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationConfig = mapped
    }

    /**
     * @param argument Configurations for sending notifications about command status changes on a per-instance basis. Documented below.
     */
    @JvmName("baftcryggfsnwgca")
    public suspend fun notificationConfig(argument: suspend MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.notificationConfig = mapped
    }

    /**
     * @param value The name of the Amazon S3 bucket.
     */
    @JvmName("lxlemwarejebutvc")
    public suspend fun outputS3Bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputS3Bucket = mapped
    }

    /**
     * @param value The Amazon S3 bucket subfolder.
     */
    @JvmName("cwfjnqdnqgpljjae")
    public suspend fun outputS3KeyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputS3KeyPrefix = mapped
    }

    /**
     * @param value The parameters for the RUN_COMMAND task execution. Documented below.
     */
    @JvmName("pvekrkijfbxfmcyg")
    public suspend fun parameters(`value`: List<MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters for the RUN_COMMAND task execution. Documented below.
     */
    @JvmName("tvwrpgoeywkxghsq")
    public suspend fun parameters(argument: List<suspend MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters for the RUN_COMMAND task execution. Documented below.
     */
    @JvmName("vifrnrsnafcmikvm")
    public suspend fun parameters(vararg argument: suspend MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters for the RUN_COMMAND task execution. Documented below.
     */
    @JvmName("ptdrxeawqldwywjv")
    public suspend fun parameters(argument: suspend MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameters for the RUN_COMMAND task execution. Documented below.
     */
    @JvmName("kmqpppyajxwjvifm")
    public suspend fun parameters(vararg values: MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.
     */
    @JvmName("prsbvoelgjdyqhcc")
    public suspend fun serviceRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRoleArn = mapped
    }

    /**
     * @param value If this time is reached and the command has not already started executing, it doesn't run.
     */
    @JvmName("oeciqxlvuspwusta")
    public suspend fun timeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutSeconds = mapped
    }

    internal fun build(): MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs =
        MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs(
            cloudwatchConfig = cloudwatchConfig,
            comment = comment,
            documentHash = documentHash,
            documentHashType = documentHashType,
            documentVersion = documentVersion,
            notificationConfig = notificationConfig,
            outputS3Bucket = outputS3Bucket,
            outputS3KeyPrefix = outputS3KeyPrefix,
            parameters = parameters,
            serviceRoleArn = serviceRoleArn,
            timeoutSeconds = timeoutSeconds,
        )
}
