@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchLogGroupName The name of the CloudWatch log group where you want to send command output. If you don't specify a group name, Systems Manager automatically creates a log group for you. The log group uses the following naming format: aws/ssm/SystemsManagerDocumentName.
 * @property cloudwatchOutputEnabled Enables Systems Manager to send command output to CloudWatch Logs.
 */
public data class
MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfigArgs(
    public val cloudwatchLogGroupName: Output<String>? = null,
    public val cloudwatchOutputEnabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfigArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfigArgs =
        com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfigArgs.builder()
            .cloudwatchLogGroupName(cloudwatchLogGroupName?.applyValue({ args0 -> args0 }))
            .cloudwatchOutputEnabled(cloudwatchOutputEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfigArgs].
 */
@PulumiTagMarker
public class
MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfigArgsBuilder
internal constructor() {
    private var cloudwatchLogGroupName: Output<String>? = null

    private var cloudwatchOutputEnabled: Output<Boolean>? = null

    /**
     * @param value The name of the CloudWatch log group where you want to send command output. If you don't specify a group name, Systems Manager automatically creates a log group for you. The log group uses the following naming format: aws/ssm/SystemsManagerDocumentName.
     */
    @JvmName("sqyqdabbfacymybl")
    public suspend fun cloudwatchLogGroupName(`value`: Output<String>) {
        this.cloudwatchLogGroupName = value
    }

    /**
     * @param value Enables Systems Manager to send command output to CloudWatch Logs.
     */
    @JvmName("xqbfjtjunchgcavi")
    public suspend fun cloudwatchOutputEnabled(`value`: Output<Boolean>) {
        this.cloudwatchOutputEnabled = value
    }

    /**
     * @param value The name of the CloudWatch log group where you want to send command output. If you don't specify a group name, Systems Manager automatically creates a log group for you. The log group uses the following naming format: aws/ssm/SystemsManagerDocumentName.
     */
    @JvmName("qnpcouqidpjoopnj")
    public suspend fun cloudwatchLogGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogGroupName = mapped
    }

    /**
     * @param value Enables Systems Manager to send command output to CloudWatch Logs.
     */
    @JvmName("mndukoqgfuikbhyw")
    public suspend fun cloudwatchOutputEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchOutputEnabled = mapped
    }

    internal fun build(): MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfigArgs =
        MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfigArgs(
            cloudwatchLogGroupName = cloudwatchLogGroupName,
            cloudwatchOutputEnabled = cloudwatchOutputEnabled,
        )
}
