@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property notificationArn An Amazon Resource Name (ARN) for a Simple Notification Service (SNS) topic. Run Command pushes notifications about command status changes to this topic.
 * @property notificationEvents The different events for which you can receive notifications. Valid values: `All`, `InProgress`, `Success`, `TimedOut`, `Cancelled`, and `Failed`
 * @property notificationType When specified with `Command`, receive notification when the status of a command changes. When specified with `Invocation`, for commands sent to multiple instances, receive notification on a per-instance basis when the status of a command changes. Valid values: `Command` and `Invocation`
 */
public data class
MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs(
    public val notificationArn: Output<String>? = null,
    public val notificationEvents: Output<List<String>>? = null,
    public val notificationType: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs =
        com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs.builder()
            .notificationArn(notificationArn?.applyValue({ args0 -> args0 }))
            .notificationEvents(notificationEvents?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .notificationType(notificationType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs].
 */
@PulumiTagMarker
public class
MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgsBuilder
internal constructor() {
    private var notificationArn: Output<String>? = null

    private var notificationEvents: Output<List<String>>? = null

    private var notificationType: Output<String>? = null

    /**
     * @param value An Amazon Resource Name (ARN) for a Simple Notification Service (SNS) topic. Run Command pushes notifications about command status changes to this topic.
     */
    @JvmName("vblurqyrcnoixxeu")
    public suspend fun notificationArn(`value`: Output<String>) {
        this.notificationArn = value
    }

    /**
     * @param value The different events for which you can receive notifications. Valid values: `All`, `InProgress`, `Success`, `TimedOut`, `Cancelled`, and `Failed`
     */
    @JvmName("ggskskflcjtwuhlm")
    public suspend fun notificationEvents(`value`: Output<List<String>>) {
        this.notificationEvents = value
    }

    @JvmName("maqtujxkpnhnevrb")
    public suspend fun notificationEvents(vararg values: Output<String>) {
        this.notificationEvents = Output.all(values.asList())
    }

    /**
     * @param values The different events for which you can receive notifications. Valid values: `All`, `InProgress`, `Success`, `TimedOut`, `Cancelled`, and `Failed`
     */
    @JvmName("pdjdsaoniltvxdrc")
    public suspend fun notificationEvents(values: List<Output<String>>) {
        this.notificationEvents = Output.all(values)
    }

    /**
     * @param value When specified with `Command`, receive notification when the status of a command changes. When specified with `Invocation`, for commands sent to multiple instances, receive notification on a per-instance basis when the status of a command changes. Valid values: `Command` and `Invocation`
     */
    @JvmName("gmgqcaobsufvyrnk")
    public suspend fun notificationType(`value`: Output<String>) {
        this.notificationType = value
    }

    /**
     * @param value An Amazon Resource Name (ARN) for a Simple Notification Service (SNS) topic. Run Command pushes notifications about command status changes to this topic.
     */
    @JvmName("godgrneauhbktfmi")
    public suspend fun notificationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationArn = mapped
    }

    /**
     * @param value The different events for which you can receive notifications. Valid values: `All`, `InProgress`, `Success`, `TimedOut`, `Cancelled`, and `Failed`
     */
    @JvmName("pguapptrebaomqcm")
    public suspend fun notificationEvents(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationEvents = mapped
    }

    /**
     * @param values The different events for which you can receive notifications. Valid values: `All`, `InProgress`, `Success`, `TimedOut`, `Cancelled`, and `Failed`
     */
    @JvmName("cmclcyjpwcmxsecv")
    public suspend fun notificationEvents(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationEvents = mapped
    }

    /**
     * @param value When specified with `Command`, receive notification when the status of a command changes. When specified with `Invocation`, for commands sent to multiple instances, receive notification on a per-instance basis when the status of a command changes. Valid values: `Command` and `Invocation`
     */
    @JvmName("ogfcxlmxrbiuujhn")
    public suspend fun notificationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationType = mapped
    }

    internal fun build(): MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs =
        MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs(
            notificationArn = notificationArn,
            notificationEvents = notificationEvents,
            notificationType = notificationType,
        )
}
