@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name The parameter name.
 * @property values The array of strings.
 */
public data class MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs(
    public val name: Output<String>,
    public val values: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs =
        com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs].
 */
@PulumiTagMarker
public class MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgsBuilder
internal constructor() {
    private var name: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value The parameter name.
     */
    @JvmName("qtytssqbqfybpdhm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The array of strings.
     */
    @JvmName("jemsrjxkquojuugn")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("mjjexfalovitooml")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The array of strings.
     */
    @JvmName("xbckwnkekqjkrkds")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The parameter name.
     */
    @JvmName("wksoplsjfqhhtudq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The array of strings.
     */
    @JvmName("vcpuscjgvckroxpk")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values The array of strings.
     */
    @JvmName("qvaeenfxcpffjfrw")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs =
        MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            values = values ?: throw PulumiNullFieldException("values"),
        )
}
