@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property input The inputs for the STEP_FUNCTION task.
 * @property name The name of the STEP_FUNCTION task.
 */
public data class MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs(
    public val input: Output<String>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs =
        com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs.builder()
            .input(input?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs].
 */
@PulumiTagMarker
public class MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgsBuilder
internal constructor() {
    private var input: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The inputs for the STEP_FUNCTION task.
     */
    @JvmName("bsglewehevajtofl")
    public suspend fun input(`value`: Output<String>) {
        this.input = value
    }

    /**
     * @param value The name of the STEP_FUNCTION task.
     */
    @JvmName("rnjxfvbvhafectcf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The inputs for the STEP_FUNCTION task.
     */
    @JvmName("ajeqybdqgqpcerlj")
    public suspend fun input(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param value The name of the STEP_FUNCTION task.
     */
    @JvmName("giqrpjvbsbofrhbg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs =
        MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs(
            input = input,
            name = name,
        )
}
