@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property s3BucketName The S3 bucket name.
 * @property s3KeyPrefix The S3 bucket prefix. Results stored in the root if not configured.
 * @property s3Region The S3 bucket region.
 * Targets specify what instance IDs or tags to apply the document to and has these keys:
 */
public data class AssociationOutputLocation(
    public val s3BucketName: String,
    public val s3KeyPrefix: String? = null,
    public val s3Region: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.AssociationOutputLocation): AssociationOutputLocation = AssociationOutputLocation(
            s3BucketName = javaType.s3BucketName(),
            s3KeyPrefix = javaType.s3KeyPrefix().map({ args0 -> args0 }).orElse(null),
            s3Region = javaType.s3Region().map({ args0 -> args0 }).orElse(null),
        )
    }
}
