@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property key Either `InstanceIds` or `tag:Tag Name` to specify an EC2 tag.
 * @property values A list of instance IDs or tag values. AWS currently limits this list size to one value.
 */
public data class AssociationTarget(
    public val key: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.AssociationTarget): AssociationTarget =
            AssociationTarget(
                key = javaType.key(),
                values = javaType.values().map({ args0 -> args0 }),
            )
    }
}
