@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dailySettings
 * @property monthlySettings (Optional) Information about on-call rotations that recur monthly. See Monthly Settings for more details.
 * @property numberOfOnCalls (Required) The number of contacts, or shift team members designated to be on call concurrently during a shift.
 * @property recurrenceMultiplier (Required) The number of days, weeks, or months a single rotation lasts.
 * @property shiftCoverages (Optional) Information about the days of the week that the on-call rotation coverage includes. See Shift Coverages for more details.
 * @property weeklySettings (Optional) Information about on-call rotations that recur weekly. See Weekly Settings for more details.
 */
public data class ContactsRotationRecurrence(
    public val dailySettings: List<ContactsRotationRecurrenceDailySetting>? = null,
    public val monthlySettings: List<ContactsRotationRecurrenceMonthlySetting>? = null,
    public val numberOfOnCalls: Int,
    public val recurrenceMultiplier: Int,
    public val shiftCoverages: List<ContactsRotationRecurrenceShiftCoverage>? = null,
    public val weeklySettings: List<ContactsRotationRecurrenceWeeklySetting>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.ContactsRotationRecurrence): ContactsRotationRecurrence = ContactsRotationRecurrence(
            dailySettings = javaType.dailySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssm.kotlin.outputs.ContactsRotationRecurrenceDailySetting.Companion.toKotlin(args0)
                })
            }),
            monthlySettings = javaType.monthlySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssm.kotlin.outputs.ContactsRotationRecurrenceMonthlySetting.Companion.toKotlin(args0)
                })
            }),
            numberOfOnCalls = javaType.numberOfOnCalls(),
            recurrenceMultiplier = javaType.recurrenceMultiplier(),
            shiftCoverages = javaType.shiftCoverages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssm.kotlin.outputs.ContactsRotationRecurrenceShiftCoverage.Companion.toKotlin(args0)
                })
            }),
            weeklySettings = javaType.weeklySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssm.kotlin.outputs.ContactsRotationRecurrenceWeeklySetting.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
