@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dayOfWeek (Required) The day of the week when the shift coverage occurs.
 * @property handOffTime (Required) The hand off time. See Hand Off Time for more details.
 */
public data class ContactsRotationRecurrenceWeeklySetting(
    public val dayOfWeek: String,
    public val handOffTime: ContactsRotationRecurrenceWeeklySettingHandOffTime? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.ContactsRotationRecurrenceWeeklySetting): ContactsRotationRecurrenceWeeklySetting = ContactsRotationRecurrenceWeeklySetting(
            dayOfWeek = javaType.dayOfWeek(),
            handOffTime = javaType.handOffTime().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssm.kotlin.outputs.ContactsRotationRecurrenceWeeklySettingHandOffTime.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
