@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property key The key of a key-value pair that identifies the location of an attachment to the document. Valid values: `SourceUrl`, `S3FileUrl`, `AttachmentReference`.
 * @property name The name of the document attachment file.
 * @property values The value of a key-value pair that identifies the location of an attachment to the document. The argument format is a list of a single string that depends on the type of key you specify - see the [API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_AttachmentsSource.html) for details.
 */
public data class DocumentAttachmentsSource(
    public val key: String,
    public val name: String? = null,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.DocumentAttachmentsSource): DocumentAttachmentsSource = DocumentAttachmentsSource(
            key = javaType.key(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
