@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property defaultValue If specified, the default values for the parameters. Parameters without a default value are required. Parameters with a default value are optional.
 * @property description A description of what the parameter does, how to use it, the default value, and whether or not the parameter is optional.
 * @property name The name of the document.
 * @property type The type of parameter. Valid values: `String`, `StringList`.
 */
public data class DocumentParameter(
    public val defaultValue: String? = null,
    public val description: String? = null,
    public val name: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.DocumentParameter): DocumentParameter =
            DocumentParameter(
                defaultValue = javaType.defaultValue().map({ args0 -> args0 }).orElse(null),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                type = javaType.type().map({ args0 -> args0 }).orElse(null),
            )
    }
}
