@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dailySettings
 * @property monthlySettings
 * @property numberOfOnCalls
 * @property recurrenceMultiplier
 * @property shiftCoverages
 * @property weeklySettings
 */
public data class GetContactsRotationRecurrence(
    public val dailySettings: List<GetContactsRotationRecurrenceDailySetting>,
    public val monthlySettings: List<GetContactsRotationRecurrenceMonthlySetting>,
    public val numberOfOnCalls: Int,
    public val recurrenceMultiplier: Int,
    public val shiftCoverages: List<GetContactsRotationRecurrenceShiftCoverage>,
    public val weeklySettings: List<GetContactsRotationRecurrenceWeeklySetting>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.GetContactsRotationRecurrence): GetContactsRotationRecurrence = GetContactsRotationRecurrence(
            dailySettings = javaType.dailySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssm.kotlin.outputs.GetContactsRotationRecurrenceDailySetting.Companion.toKotlin(args0)
                })
            }),
            monthlySettings = javaType.monthlySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssm.kotlin.outputs.GetContactsRotationRecurrenceMonthlySetting.Companion.toKotlin(args0)
                })
            }),
            numberOfOnCalls = javaType.numberOfOnCalls(),
            recurrenceMultiplier = javaType.recurrenceMultiplier(),
            shiftCoverages = javaType.shiftCoverages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssm.kotlin.outputs.GetContactsRotationRecurrenceShiftCoverage.Companion.toKotlin(args0)
                })
            }),
            weeklySettings = javaType.weeklySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssm.kotlin.outputs.GetContactsRotationRecurrenceWeeklySetting.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
