@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getContactsRotation.
 * @property arn
 * @property contactIds The Amazon Resource Names (ARNs) of the contacts to add to the rotation. The order in which you list the contacts is their shift order in the rotation schedule.
 * @property id
 * @property name The name for the rotation.
 * @property recurrences Information about when an on-call rotation is in effect and how long the rotation period lasts.
 * @property startTime The date and time, in RFC 3339 format, that the rotation goes into effect.
 * @property tags A map of tags to assign to the resource.
 * @property timeZoneId The time zone to base the rotation’s activity on in Internet Assigned Numbers Authority (IANA) format.
 */
public data class GetContactsRotationResult(
    public val arn: String,
    public val contactIds: List<String>,
    public val id: String,
    public val name: String,
    public val recurrences: List<GetContactsRotationRecurrence>,
    public val startTime: String,
    public val tags: Map<String, String>,
    public val timeZoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.GetContactsRotationResult): GetContactsRotationResult = GetContactsRotationResult(
            arn = javaType.arn(),
            contactIds = javaType.contactIds().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            recurrences = javaType.recurrences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssm.kotlin.outputs.GetContactsRotationRecurrence.Companion.toKotlin(args0)
                })
            }),
            startTime = javaType.startTime(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeZoneId = javaType.timeZoneId(),
        )
    }
}
