@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getDocument.
 * @property arn ARN of the document. If the document is an AWS managed document, this value will be set to the name of the document instead.
 * @property content The content for the SSM document in JSON or YAML format.
 * @property documentFormat
 * @property documentType The type of the document.
 * @property documentVersion
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 */
public data class GetDocumentResult(
    public val arn: String,
    public val content: String,
    public val documentFormat: String? = null,
    public val documentType: String,
    public val documentVersion: String? = null,
    public val id: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.GetDocumentResult): GetDocumentResult =
            GetDocumentResult(
                arn = javaType.arn(),
                content = javaType.content(),
                documentFormat = javaType.documentFormat().map({ args0 -> args0 }).orElse(null),
                documentType = javaType.documentType(),
                documentVersion = javaType.documentVersion().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                name = javaType.name(),
            )
    }
}
