@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPatchBaseline.
 * @property approvalRules List of rules used to include patches in the baseline.
 * @property approvedPatches List of explicitly approved patches for the baseline.
 * @property approvedPatchesComplianceLevel Compliance level for approved patches.
 * @property approvedPatchesEnableNonSecurity Indicates whether the list of approved patches includes non-security updates that should be applied to the instances.
 * @property defaultBaseline
 * @property description Description of the baseline.
 * @property globalFilters Set of global filters used to exclude patches from the baseline.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property json JSON representation of the baseline.
 * @property name Name specified to identify the patch source.
 * @property namePrefix
 * @property operatingSystem
 * @property owner
 * @property rejectedPatches List of rejected patches.
 * @property rejectedPatchesAction Action specified to take on patches included in the `rejected_patches` list.
 * @property sources Information about the patches to use to update the managed nodes, including target operating systems and source repositories.
 */
public data class GetPatchBaselineResult(
    public val approvalRules: List<GetPatchBaselineApprovalRule>,
    public val approvedPatches: List<String>,
    public val approvedPatchesComplianceLevel: String,
    public val approvedPatchesEnableNonSecurity: Boolean,
    public val defaultBaseline: Boolean? = null,
    public val description: String,
    public val globalFilters: List<GetPatchBaselineGlobalFilter>,
    public val id: String,
    public val json: String,
    public val name: String,
    public val namePrefix: String? = null,
    public val operatingSystem: String? = null,
    public val owner: String,
    public val rejectedPatches: List<String>,
    public val rejectedPatchesAction: String,
    public val sources: List<GetPatchBaselineSource>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.GetPatchBaselineResult): GetPatchBaselineResult = GetPatchBaselineResult(
            approvalRules = javaType.approvalRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssm.kotlin.outputs.GetPatchBaselineApprovalRule.Companion.toKotlin(args0)
                })
            }),
            approvedPatches = javaType.approvedPatches().map({ args0 -> args0 }),
            approvedPatchesComplianceLevel = javaType.approvedPatchesComplianceLevel(),
            approvedPatchesEnableNonSecurity = javaType.approvedPatchesEnableNonSecurity(),
            defaultBaseline = javaType.defaultBaseline().map({ args0 -> args0 }).orElse(null),
            description = javaType.description(),
            globalFilters = javaType.globalFilters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssm.kotlin.outputs.GetPatchBaselineGlobalFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            json = javaType.json(),
            name = javaType.name(),
            namePrefix = javaType.namePrefix().map({ args0 -> args0 }).orElse(null),
            operatingSystem = javaType.operatingSystem().map({ args0 -> args0 }).orElse(null),
            owner = javaType.owner(),
            rejectedPatches = javaType.rejectedPatches().map({ args0 -> args0 }),
            rejectedPatchesAction = javaType.rejectedPatchesAction(),
            sources = javaType.sources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssm.kotlin.outputs.GetPatchBaselineSource.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
