@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property documentVersion The version of an Automation document to use during task execution.
 * @property parameters The parameters for the RUN_COMMAND task execution. Documented below.
 */
public data class MaintenanceWindowTaskTaskInvocationParametersAutomationParameters(
    public val documentVersion: String? = null,
    public val parameters: List<MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameter>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParameters): MaintenanceWindowTaskTaskInvocationParametersAutomationParameters =
            MaintenanceWindowTaskTaskInvocationParametersAutomationParameters(
                documentVersion = javaType.documentVersion().map({ args0 -> args0 }).orElse(null),
                parameters = javaType.parameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ssm.kotlin.outputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameter.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
