@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cloudwatchConfig Configuration options for sending command output to CloudWatch Logs. Documented below.
 * @property comment Information about the command(s) to execute.
 * @property documentHash The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes have been deprecated.
 * @property documentHashType SHA-256 or SHA-1. SHA-1 hashes have been deprecated. Valid values: `Sha256` and `Sha1`
 * @property documentVersion The version of an Automation document to use during task execution.
 * @property notificationConfig Configurations for sending notifications about command status changes on a per-instance basis. Documented below.
 * @property outputS3Bucket The name of the Amazon S3 bucket.
 * @property outputS3KeyPrefix The Amazon S3 bucket subfolder.
 * @property parameters The parameters for the RUN_COMMAND task execution. Documented below.
 * @property serviceRoleArn The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.
 * @property timeoutSeconds If this time is reached and the command has not already started executing, it doesn't run.
 */
public data class MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters(
    public val cloudwatchConfig: MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig? = null,
    public val comment: String? = null,
    public val documentHash: String? = null,
    public val documentHashType: String? = null,
    public val documentVersion: String? = null,
    public val notificationConfig: MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig? = null,
    public val outputS3Bucket: String? = null,
    public val outputS3KeyPrefix: String? = null,
    public val parameters: List<MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameter>? = null,
    public val serviceRoleArn: String? = null,
    public val timeoutSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters): MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters =
            MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters(
                cloudwatchConfig = javaType.cloudwatchConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ssm.kotlin.outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                comment = javaType.comment().map({ args0 -> args0 }).orElse(null),
                documentHash = javaType.documentHash().map({ args0 -> args0 }).orElse(null),
                documentHashType = javaType.documentHashType().map({ args0 -> args0 }).orElse(null),
                documentVersion = javaType.documentVersion().map({ args0 -> args0 }).orElse(null),
                notificationConfig = javaType.notificationConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ssm.kotlin.outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                outputS3Bucket = javaType.outputS3Bucket().map({ args0 -> args0 }).orElse(null),
                outputS3KeyPrefix = javaType.outputS3KeyPrefix().map({ args0 -> args0 }).orElse(null),
                parameters = javaType.parameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ssm.kotlin.outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameter.Companion.toKotlin(args0)
                    })
                }),
                serviceRoleArn = javaType.serviceRoleArn().map({ args0 -> args0 }).orElse(null),
                timeoutSeconds = javaType.timeoutSeconds().map({ args0 -> args0 }).orElse(null),
            )
    }
}
