@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property configuration Value of the yum repo configuration. For information about other options available for your yum repository configuration, see the [`dnf&#46;conf` documentation](https://man7.org/linux/man-pages/man5/dnf.conf.5.html)
 * @property name Name specified to identify the patch source.
 * @property products Specific operating system versions a patch repository applies to, such as `"Ubuntu16.04"`, `"AmazonLinux2016.09"`, `"RedhatEnterpriseLinux7.2"` or `"Suse12.7"`. For lists of supported product values, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html).
 */
public data class PatchBaselineSource(
    public val configuration: String,
    public val name: String,
    public val products: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.PatchBaselineSource): PatchBaselineSource = PatchBaselineSource(
            configuration = javaType.configuration(),
            name = javaType.name(),
            products = javaType.products().map({ args0 -> args0 }),
        )
    }
}
