@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName Name of S3 bucket where the aggregated data is stored.
 * @property kmsKeyArn ARN of an encryption key for a destination in Amazon S3.
 * @property prefix Prefix for the bucket.
 * @property region Region with the bucket targeted by the Resource Data Sync.
 * @property syncFormat A supported sync format. Only JsonSerDe is currently supported. Defaults to JsonSerDe.
 */
public data class ResourceDataSyncS3Destination(
    public val bucketName: String,
    public val kmsKeyArn: String? = null,
    public val prefix: String? = null,
    public val region: String,
    public val syncFormat: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.ResourceDataSyncS3Destination): ResourceDataSyncS3Destination = ResourceDataSyncS3Destination(
            bucketName = javaType.bucketName(),
            kmsKeyArn = javaType.kmsKeyArn().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            region = javaType.region(),
            syncFormat = javaType.syncFormat().map({ args0 -> args0 }).orElse(null),
        )
    }
}
