@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin.inputs

import com.pulumi.aws.ssmcontacts.inputs.GetContactChannelPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getContactChannel.
 * @property arn Amazon Resource Name (ARN) of the contact channel.
 */
public data class GetContactChannelPlainArgs(
    public val arn: String,
) : ConvertibleToJava<com.pulumi.aws.ssmcontacts.inputs.GetContactChannelPlainArgs> {
    override fun toJava(): com.pulumi.aws.ssmcontacts.inputs.GetContactChannelPlainArgs =
        com.pulumi.aws.ssmcontacts.inputs.GetContactChannelPlainArgs.builder()
            .arn(arn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContactChannelPlainArgs].
 */
@PulumiTagMarker
public class GetContactChannelPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    /**
     * @param value Amazon Resource Name (ARN) of the contact channel.
     */
    @JvmName("yngmyxlqlehfhgwp")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    internal fun build(): GetContactChannelPlainArgs = GetContactChannelPlainArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
    )
}
