@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin.inputs

import com.pulumi.aws.ssmcontacts.inputs.GetContactPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getContact.
 * @property arn The Amazon Resource Name (ARN) of the contact or escalation plan.
 * @property tags Map of tags to assign to the resource.
 */
public data class GetContactPlainArgs(
    public val arn: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssmcontacts.inputs.GetContactPlainArgs> {
    override fun toJava(): com.pulumi.aws.ssmcontacts.inputs.GetContactPlainArgs =
        com.pulumi.aws.ssmcontacts.inputs.GetContactPlainArgs.builder()
            .arn(arn.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetContactPlainArgs].
 */
@PulumiTagMarker
public class GetContactPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the contact or escalation plan.
     */
    @JvmName("ylwkkfsxscdgwiyc")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Map of tags to assign to the resource.
     */
    @JvmName("wxabrtiuiydmfmmb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource.
     */
    @JvmName("mbjilrhrdkguscit")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetContactPlainArgs = GetContactPlainArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
        tags = tags,
    )
}
