@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin.inputs

import com.pulumi.aws.ssmcontacts.inputs.PlanStageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property durationInMinutes The time to wait until beginning the next stage. The duration can only be set to 0 if a target is specified.
 * @property targets One or more configuration blocks for specifying the contacts or contact methods that the escalation plan or engagement plan is engaging. See Target below for more details.
 */
public data class PlanStageArgs(
    public val durationInMinutes: Output<Int>,
    public val targets: Output<List<PlanStageTargetArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssmcontacts.inputs.PlanStageArgs> {
    override fun toJava(): com.pulumi.aws.ssmcontacts.inputs.PlanStageArgs =
        com.pulumi.aws.ssmcontacts.inputs.PlanStageArgs.builder()
            .durationInMinutes(durationInMinutes.applyValue({ args0 -> args0 }))
            .targets(
                targets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PlanStageArgs].
 */
@PulumiTagMarker
public class PlanStageArgsBuilder internal constructor() {
    private var durationInMinutes: Output<Int>? = null

    private var targets: Output<List<PlanStageTargetArgs>>? = null

    /**
     * @param value The time to wait until beginning the next stage. The duration can only be set to 0 if a target is specified.
     */
    @JvmName("oydlxiqldbbhxkwj")
    public suspend fun durationInMinutes(`value`: Output<Int>) {
        this.durationInMinutes = value
    }

    /**
     * @param value One or more configuration blocks for specifying the contacts or contact methods that the escalation plan or engagement plan is engaging. See Target below for more details.
     */
    @JvmName("gglwkaaxvaguualx")
    public suspend fun targets(`value`: Output<List<PlanStageTargetArgs>>) {
        this.targets = value
    }

    @JvmName("biblhyuflvqbmppo")
    public suspend fun targets(vararg values: Output<PlanStageTargetArgs>) {
        this.targets = Output.all(values.asList())
    }

    /**
     * @param values One or more configuration blocks for specifying the contacts or contact methods that the escalation plan or engagement plan is engaging. See Target below for more details.
     */
    @JvmName("rjymcttrmfjrjbhv")
    public suspend fun targets(values: List<Output<PlanStageTargetArgs>>) {
        this.targets = Output.all(values)
    }

    /**
     * @param value The time to wait until beginning the next stage. The duration can only be set to 0 if a target is specified.
     */
    @JvmName("taafohhvwbasowrv")
    public suspend fun durationInMinutes(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.durationInMinutes = mapped
    }

    /**
     * @param value One or more configuration blocks for specifying the contacts or contact methods that the escalation plan or engagement plan is engaging. See Target below for more details.
     */
    @JvmName("iglbbobelflilotx")
    public suspend fun targets(`value`: List<PlanStageTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param argument One or more configuration blocks for specifying the contacts or contact methods that the escalation plan or engagement plan is engaging. See Target below for more details.
     */
    @JvmName("vstvgatqwapabdlg")
    public suspend fun targets(argument: List<suspend PlanStageTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PlanStageTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument One or more configuration blocks for specifying the contacts or contact methods that the escalation plan or engagement plan is engaging. See Target below for more details.
     */
    @JvmName("evxddngssgltajdy")
    public suspend fun targets(vararg argument: suspend PlanStageTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PlanStageTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument One or more configuration blocks for specifying the contacts or contact methods that the escalation plan or engagement plan is engaging. See Target below for more details.
     */
    @JvmName("cswdqvephtwbdllq")
    public suspend fun targets(argument: suspend PlanStageTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PlanStageTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param values One or more configuration blocks for specifying the contacts or contact methods that the escalation plan or engagement plan is engaging. See Target below for more details.
     */
    @JvmName("ymplogvnunbygvwy")
    public suspend fun targets(vararg values: PlanStageTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    internal fun build(): PlanStageArgs = PlanStageArgs(
        durationInMinutes = durationInMinutes ?: throw PulumiNullFieldException("durationInMinutes"),
        targets = targets,
    )
}
