@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin.inputs

import com.pulumi.aws.ssmcontacts.inputs.PlanStageTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property channelTargetInfo A configuration block for specifying information about the contact channel that Incident Manager engages. See Channel Target Info for more details.
 * @property contactTargetInfo A configuration block for specifying information about the contact that Incident Manager engages. See Contact Target Info for more details.
 */
public data class PlanStageTargetArgs(
    public val channelTargetInfo: Output<PlanStageTargetChannelTargetInfoArgs>? = null,
    public val contactTargetInfo: Output<PlanStageTargetContactTargetInfoArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssmcontacts.inputs.PlanStageTargetArgs> {
    override fun toJava(): com.pulumi.aws.ssmcontacts.inputs.PlanStageTargetArgs =
        com.pulumi.aws.ssmcontacts.inputs.PlanStageTargetArgs.builder()
            .channelTargetInfo(channelTargetInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .contactTargetInfo(
                contactTargetInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [PlanStageTargetArgs].
 */
@PulumiTagMarker
public class PlanStageTargetArgsBuilder internal constructor() {
    private var channelTargetInfo: Output<PlanStageTargetChannelTargetInfoArgs>? = null

    private var contactTargetInfo: Output<PlanStageTargetContactTargetInfoArgs>? = null

    /**
     * @param value A configuration block for specifying information about the contact channel that Incident Manager engages. See Channel Target Info for more details.
     */
    @JvmName("ywumnlrymksrxqea")
    public suspend fun channelTargetInfo(`value`: Output<PlanStageTargetChannelTargetInfoArgs>) {
        this.channelTargetInfo = value
    }

    /**
     * @param value A configuration block for specifying information about the contact that Incident Manager engages. See Contact Target Info for more details.
     */
    @JvmName("bbcesgkxjqpvkeef")
    public suspend fun contactTargetInfo(`value`: Output<PlanStageTargetContactTargetInfoArgs>) {
        this.contactTargetInfo = value
    }

    /**
     * @param value A configuration block for specifying information about the contact channel that Incident Manager engages. See Channel Target Info for more details.
     */
    @JvmName("supsqabfwjdsotnc")
    public suspend fun channelTargetInfo(`value`: PlanStageTargetChannelTargetInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelTargetInfo = mapped
    }

    /**
     * @param argument A configuration block for specifying information about the contact channel that Incident Manager engages. See Channel Target Info for more details.
     */
    @JvmName("iruidrxshbobtbur")
    public suspend fun channelTargetInfo(argument: suspend PlanStageTargetChannelTargetInfoArgsBuilder.() -> Unit) {
        val toBeMapped = PlanStageTargetChannelTargetInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.channelTargetInfo = mapped
    }

    /**
     * @param value A configuration block for specifying information about the contact that Incident Manager engages. See Contact Target Info for more details.
     */
    @JvmName("ocxqavtbfnhfvcxe")
    public suspend fun contactTargetInfo(`value`: PlanStageTargetContactTargetInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactTargetInfo = mapped
    }

    /**
     * @param argument A configuration block for specifying information about the contact that Incident Manager engages. See Contact Target Info for more details.
     */
    @JvmName("yajjmsvqqykhlovy")
    public suspend fun contactTargetInfo(argument: suspend PlanStageTargetContactTargetInfoArgsBuilder.() -> Unit) {
        val toBeMapped = PlanStageTargetContactTargetInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.contactTargetInfo = mapped
    }

    internal fun build(): PlanStageTargetArgs = PlanStageTargetArgs(
        channelTargetInfo = channelTargetInfo,
        contactTargetInfo = contactTargetInfo,
    )
}
