@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin.inputs

import com.pulumi.aws.ssmcontacts.inputs.PlanStageTargetContactTargetInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contactId The Amazon Resource Name (ARN) of the contact.
 * @property isEssential A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
 */
public data class PlanStageTargetContactTargetInfoArgs(
    public val contactId: Output<String>? = null,
    public val isEssential: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.ssmcontacts.inputs.PlanStageTargetContactTargetInfoArgs> {
    override fun toJava(): com.pulumi.aws.ssmcontacts.inputs.PlanStageTargetContactTargetInfoArgs =
        com.pulumi.aws.ssmcontacts.inputs.PlanStageTargetContactTargetInfoArgs.builder()
            .contactId(contactId?.applyValue({ args0 -> args0 }))
            .isEssential(isEssential.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PlanStageTargetContactTargetInfoArgs].
 */
@PulumiTagMarker
public class PlanStageTargetContactTargetInfoArgsBuilder internal constructor() {
    private var contactId: Output<String>? = null

    private var isEssential: Output<Boolean>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the contact.
     */
    @JvmName("vytkddawttcpakgq")
    public suspend fun contactId(`value`: Output<String>) {
        this.contactId = value
    }

    /**
     * @param value A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
     */
    @JvmName("sbdwyjcxierwunrm")
    public suspend fun isEssential(`value`: Output<Boolean>) {
        this.isEssential = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the contact.
     */
    @JvmName("aoxddlvhdchjwfpg")
    public suspend fun contactId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactId = mapped
    }

    /**
     * @param value A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
     */
    @JvmName("nmtceuutbggqwrvp")
    public suspend fun isEssential(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEssential = mapped
    }

    internal fun build(): PlanStageTargetContactTargetInfoArgs = PlanStageTargetContactTargetInfoArgs(
        contactId = contactId,
        isEssential = isEssential ?: throw PulumiNullFieldException("isEssential"),
    )
}
