@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getContactChannel.
 * @property activationStatus Whether the contact channel is activated.
 * @property arn
 * @property contactId Amazon Resource Name (ARN) of the AWS SSM Contact that the contact channel belongs to.
 * @property deliveryAddresses Details used to engage the contact channel.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of the contact channel.
 * @property type Type of the contact channel.
 */
public data class GetContactChannelResult(
    public val activationStatus: String,
    public val arn: String,
    public val contactId: String,
    public val deliveryAddresses: List<GetContactChannelDeliveryAddress>,
    public val id: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssmcontacts.outputs.GetContactChannelResult): GetContactChannelResult = GetContactChannelResult(
            activationStatus = javaType.activationStatus(),
            arn = javaType.arn(),
            contactId = javaType.contactId(),
            deliveryAddresses = javaType.deliveryAddresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssmcontacts.kotlin.outputs.GetContactChannelDeliveryAddress.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
