@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPlan.
 * @property contactId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property stages List of stages. A contact has an engagement plan with stages that contact specified contact channels. An escalation plan uses stages that contact specified contacts.
 */
public data class GetPlanResult(
    public val contactId: String,
    public val id: String,
    public val stages: List<GetPlanStage>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssmcontacts.outputs.GetPlanResult): GetPlanResult =
            GetPlanResult(
                contactId = javaType.contactId(),
                id = javaType.id(),
                stages = javaType.stages().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ssmcontacts.kotlin.outputs.GetPlanStage.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
