@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin

import com.pulumi.aws.ssmincidents.kotlin.outputs.ReplicationSetRegion
import com.pulumi.aws.ssmincidents.kotlin.outputs.ReplicationSetRegion.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ReplicationSet].
 */
@PulumiTagMarker
public class ReplicationSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationSetArgs = ReplicationSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationSetArgsBuilder.() -> Unit) {
        val builder = ReplicationSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ReplicationSet {
        val builtJavaResource = com.pulumi.aws.ssmincidents.ReplicationSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReplicationSet(builtJavaResource)
    }
}

/**
 * Provides a resource for managing a replication set in AWS Systems Manager Incident Manager.
 * > **NOTE:** Deleting a replication set also deletes all Incident Manager related data including response plans, incident records, contacts and escalation plans.
 * ## Example Usage
 * ### Basic Usage
 * Create a replication set.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const replicationSetName = new aws.ssmincidents.ReplicationSet("replicationSetName", {
 *     regions: [{
 *         name: "us-west-2",
 *     }],
 *     tags: {
 *         exampleTag: "exampleValue",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * replication_set_name = aws.ssmincidents.ReplicationSet("replicationSetName",
 *     regions=[{
 *         "name": "us-west-2",
 *     }],
 *     tags={
 *         "exampleTag": "exampleValue",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationSetName = new Aws.SsmIncidents.ReplicationSet("replicationSetName", new()
 *     {
 *         Regions = new[]
 *         {
 *             new Aws.SsmIncidents.Inputs.ReplicationSetRegionArgs
 *             {
 *                 Name = "us-west-2",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "exampleTag", "exampleValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssmincidents"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssmincidents.NewReplicationSet(ctx, "replicationSetName", &ssmincidents.ReplicationSetArgs{
 * 			Regions: ssmincidents.ReplicationSetRegionArray{
 * 				&ssmincidents.ReplicationSetRegionArgs{
 * 					Name: pulumi.String("us-west-2"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"exampleTag": pulumi.String("exampleValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmincidents.ReplicationSet;
 * import com.pulumi.aws.ssmincidents.ReplicationSetArgs;
 * import com.pulumi.aws.ssmincidents.inputs.ReplicationSetRegionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationSetName = new ReplicationSet("replicationSetName", ReplicationSetArgs.builder()
 *             .regions(ReplicationSetRegionArgs.builder()
 *                 .name("us-west-2")
 *                 .build())
 *             .tags(Map.of("exampleTag", "exampleValue"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   replicationSetName:
 *     type: aws:ssmincidents:ReplicationSet
 *     properties:
 *       regions:
 *         - name: us-west-2
 *       tags:
 *         exampleTag: exampleValue
 * ```
 * <!--End PulumiCodeChooser -->
 * Add a Region to a replication set. (You can add only one Region at a time.)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const replicationSetName = new aws.ssmincidents.ReplicationSet("replicationSetName", {regions: [
 *     {
 *         name: "us-west-2",
 *     },
 *     {
 *         name: "ap-southeast-2",
 *     },
 * ]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * replication_set_name = aws.ssmincidents.ReplicationSet("replicationSetName", regions=[
 *     {
 *         "name": "us-west-2",
 *     },
 *     {
 *         "name": "ap-southeast-2",
 *     },
 * ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationSetName = new Aws.SsmIncidents.ReplicationSet("replicationSetName", new()
 *     {
 *         Regions = new[]
 *         {
 *             new Aws.SsmIncidents.Inputs.ReplicationSetRegionArgs
 *             {
 *                 Name = "us-west-2",
 *             },
 *             new Aws.SsmIncidents.Inputs.ReplicationSetRegionArgs
 *             {
 *                 Name = "ap-southeast-2",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssmincidents"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssmincidents.NewReplicationSet(ctx, "replicationSetName", &ssmincidents.ReplicationSetArgs{
 * 			Regions: ssmincidents.ReplicationSetRegionArray{
 * 				&ssmincidents.ReplicationSetRegionArgs{
 * 					Name: pulumi.String("us-west-2"),
 * 				},
 * 				&ssmincidents.ReplicationSetRegionArgs{
 * 					Name: pulumi.String("ap-southeast-2"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmincidents.ReplicationSet;
 * import com.pulumi.aws.ssmincidents.ReplicationSetArgs;
 * import com.pulumi.aws.ssmincidents.inputs.ReplicationSetRegionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationSetName = new ReplicationSet("replicationSetName", ReplicationSetArgs.builder()
 *             .regions(
 *                 ReplicationSetRegionArgs.builder()
 *                     .name("us-west-2")
 *                     .build(),
 *                 ReplicationSetRegionArgs.builder()
 *                     .name("ap-southeast-2")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   replicationSetName:
 *     type: aws:ssmincidents:ReplicationSet
 *     properties:
 *       regions:
 *         - name: us-west-2
 *         - name: ap-southeast-2
 * ```
 * <!--End PulumiCodeChooser -->
 * Delete a Region from a replication set. (You can delete only one Region at a time.)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const replicationSetName = new aws.ssmincidents.ReplicationSet("replicationSetName", {regions: [{
 *     name: "us-west-2",
 * }]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * replication_set_name = aws.ssmincidents.ReplicationSet("replicationSetName", regions=[{
 *     "name": "us-west-2",
 * }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationSetName = new Aws.SsmIncidents.ReplicationSet("replicationSetName", new()
 *     {
 *         Regions = new[]
 *         {
 *             new Aws.SsmIncidents.Inputs.ReplicationSetRegionArgs
 *             {
 *                 Name = "us-west-2",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssmincidents"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssmincidents.NewReplicationSet(ctx, "replicationSetName", &ssmincidents.ReplicationSetArgs{
 * 			Regions: ssmincidents.ReplicationSetRegionArray{
 * 				&ssmincidents.ReplicationSetRegionArgs{
 * 					Name: pulumi.String("us-west-2"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmincidents.ReplicationSet;
 * import com.pulumi.aws.ssmincidents.ReplicationSetArgs;
 * import com.pulumi.aws.ssmincidents.inputs.ReplicationSetRegionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationSetName = new ReplicationSet("replicationSetName", ReplicationSetArgs.builder()
 *             .regions(ReplicationSetRegionArgs.builder()
 *                 .name("us-west-2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   replicationSetName:
 *     type: aws:ssmincidents:ReplicationSet
 *     properties:
 *       regions:
 *         - name: us-west-2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Basic Usage with an AWS Customer Managed Key
 * Create a replication set with an AWS Key Management Service (AWS KMS) customer manager key:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleKey = new aws.kms.Key("example_key", {});
 * const replicationSetName = new aws.ssmincidents.ReplicationSet("replicationSetName", {
 *     regions: [{
 *         name: "us-west-2",
 *         kmsKeyArn: exampleKey.arn,
 *     }],
 *     tags: {
 *         exampleTag: "exampleValue",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_key = aws.kms.Key("example_key")
 * replication_set_name = aws.ssmincidents.ReplicationSet("replicationSetName",
 *     regions=[{
 *         "name": "us-west-2",
 *         "kms_key_arn": example_key.arn,
 *     }],
 *     tags={
 *         "exampleTag": "exampleValue",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleKey = new Aws.Kms.Key("example_key");
 *     var replicationSetName = new Aws.SsmIncidents.ReplicationSet("replicationSetName", new()
 *     {
 *         Regions = new[]
 *         {
 *             new Aws.SsmIncidents.Inputs.ReplicationSetRegionArgs
 *             {
 *                 Name = "us-west-2",
 *                 KmsKeyArn = exampleKey.Arn,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "exampleTag", "exampleValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssmincidents"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleKey, err := kms.NewKey(ctx, "example_key", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssmincidents.NewReplicationSet(ctx, "replicationSetName", &ssmincidents.ReplicationSetArgs{
 * 			Regions: ssmincidents.ReplicationSetRegionArray{
 * 				&ssmincidents.ReplicationSetRegionArgs{
 * 					Name:      pulumi.String("us-west-2"),
 * 					KmsKeyArn: exampleKey.Arn,
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"exampleTag": pulumi.String("exampleValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.ssmincidents.ReplicationSet;
 * import com.pulumi.aws.ssmincidents.ReplicationSetArgs;
 * import com.pulumi.aws.ssmincidents.inputs.ReplicationSetRegionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey");
 *         var replicationSetName = new ReplicationSet("replicationSetName", ReplicationSetArgs.builder()
 *             .regions(ReplicationSetRegionArgs.builder()
 *                 .name("us-west-2")
 *                 .kmsKeyArn(exampleKey.arn())
 *                 .build())
 *             .tags(Map.of("exampleTag", "exampleValue"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleKey:
 *     type: aws:kms:Key
 *     name: example_key
 *   replicationSetName:
 *     type: aws:ssmincidents:ReplicationSet
 *     properties:
 *       regions:
 *         - name: us-west-2
 *           kmsKeyArn: ${exampleKey.arn}
 *       tags:
 *         exampleTag: exampleValue
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an Incident Manager replication. For example:
 * ```sh
 * $ pulumi import aws:ssmincidents/replicationSet:ReplicationSet replicationSetName import
 * ```
 */
public class ReplicationSet internal constructor(
    override val javaResource: com.pulumi.aws.ssmincidents.ReplicationSet,
) : KotlinCustomResource(javaResource, ReplicationSetMapper) {
    /**
     * The ARN of the replication set.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the user who created the replication set.
     */
    public val createdBy: Output<String>
        get() = javaResource.createdBy().applyValue({ args0 -> args0 })

    /**
     * If `true`, the last region in a replication set cannot be deleted.
     */
    public val deletionProtected: Output<Boolean>
        get() = javaResource.deletionProtected().applyValue({ args0 -> args0 })

    /**
     * A timestamp showing when the replication set was last modified.
     */
    public val lastModifiedBy: Output<String>
        get() = javaResource.lastModifiedBy().applyValue({ args0 -> args0 })

    public val regions: Output<List<ReplicationSetRegion>>
        get() = javaResource.regions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The current status of the Region.
     * * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ReplicationSetMapper : ResourceMapper<ReplicationSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssmincidents.ReplicationSet::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationSet = ReplicationSet(
        javaResource as
            com.pulumi.aws.ssmincidents.ReplicationSet,
    )
}

/**
 * @see [ReplicationSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationSet].
 */
public suspend fun replicationSet(
    name: String,
    block: suspend ReplicationSetResourceBuilder.() -> Unit,
): ReplicationSet {
    val builder = ReplicationSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationSet(name: String): ReplicationSet {
    val builder = ReplicationSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
