@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin

import com.pulumi.aws.ssmincidents.ResponsePlanArgs.builder
import com.pulumi.aws.ssmincidents.kotlin.inputs.ResponsePlanActionArgs
import com.pulumi.aws.ssmincidents.kotlin.inputs.ResponsePlanActionArgsBuilder
import com.pulumi.aws.ssmincidents.kotlin.inputs.ResponsePlanIncidentTemplateArgs
import com.pulumi.aws.ssmincidents.kotlin.inputs.ResponsePlanIncidentTemplateArgsBuilder
import com.pulumi.aws.ssmincidents.kotlin.inputs.ResponsePlanIntegrationArgs
import com.pulumi.aws.ssmincidents.kotlin.inputs.ResponsePlanIntegrationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage response plans in AWS Systems Manager Incident Manager.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssmincidents.ResponsePlan("example", {
 *     name: "name",
 *     incidentTemplate: {
 *         title: "title",
 *         impact: 3,
 *     },
 *     tags: {
 *         key: "value",
 *     },
 * }, {
 *     dependsOn: [exampleAwsSsmincidentsReplicationSet],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssmincidents.ResponsePlan("example",
 *     name="name",
 *     incident_template={
 *         "title": "title",
 *         "impact": 3,
 *     },
 *     tags={
 *         "key": "value",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_ssmincidents_replication_set]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SsmIncidents.ResponsePlan("example", new()
 *     {
 *         Name = "name",
 *         IncidentTemplate = new Aws.SsmIncidents.Inputs.ResponsePlanIncidentTemplateArgs
 *         {
 *             Title = "title",
 *             Impact = 3,
 *         },
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsSsmincidentsReplicationSet,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssmincidents"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssmincidents.NewResponsePlan(ctx, "example", &ssmincidents.ResponsePlanArgs{
 * 			Name: pulumi.String("name"),
 * 			IncidentTemplate: &ssmincidents.ResponsePlanIncidentTemplateArgs{
 * 				Title:  pulumi.String("title"),
 * 				Impact: pulumi.Int(3),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsSsmincidentsReplicationSet,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmincidents.ResponsePlan;
 * import com.pulumi.aws.ssmincidents.ResponsePlanArgs;
 * import com.pulumi.aws.ssmincidents.inputs.ResponsePlanIncidentTemplateArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResponsePlan("example", ResponsePlanArgs.builder()
 *             .name("name")
 *             .incidentTemplate(ResponsePlanIncidentTemplateArgs.builder()
 *                 .title("title")
 *                 .impact("3")
 *                 .build())
 *             .tags(Map.of("key", "value"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsSsmincidentsReplicationSet)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssmincidents:ResponsePlan
 *     properties:
 *       name: name
 *       incidentTemplate:
 *         title: title
 *         impact: '3'
 *       tags:
 *         key: value
 *     options:
 *       dependson:
 *         - ${exampleAwsSsmincidentsReplicationSet}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Usage With All Fields
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssmincidents.ResponsePlan("example", {
 *     name: "name",
 *     incidentTemplate: {
 *         title: "title",
 *         impact: 3,
 *         dedupeString: "dedupe",
 *         incidentTags: {
 *             key: "value",
 *         },
 *         notificationTargets: [
 *             {
 *                 snsTopicArn: example1.arn,
 *             },
 *             {
 *                 snsTopicArn: example2.arn,
 *             },
 *         ],
 *         summary: "summary",
 *     },
 *     displayName: "display name",
 *     chatChannels: [topic&#46;arn],
 *     engagements: ["arn:aws:ssm-contacts:us-east-2:111122223333:contact/test1"],
 *     action: {
 *         ssmAutomations: [{
 *             documentName: document1.name,
 *             roleArn: role1.arn,
 *             documentVersion: "version1",
 *             targetAccount: "RESPONSE_PLAN_OWNER_ACCOUNT",
 *             parameters: [
 *                 {
 *                     name: "key",
 *                     values: [
 *                         "value1",
 *                         "value2",
 *                     ],
 *                 },
 *                 {
 *                     name: "foo",
 *                     values: ["bar"],
 *                 },
 *             ],
 *             dynamicParameters: {
 *                 someKey: "INVOLVED_RESOURCES",
 *                 anotherKey: "INCIDENT_RECORD_ARN",
 *             },
 *         }],
 *     },
 *     integration: {
 *         pagerduties: [{
 *             name: "pagerdutyIntergration",
 *             serviceId: "example",
 *             secretId: "example",
 *         }],
 *     },
 *     tags: {
 *         key: "value",
 *     },
 * }, {
 *     dependsOn: [exampleAwsSsmincidentsReplicationSet],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssmincidents.ResponsePlan("example",
 *     name="name",
 *     incident_template={
 *         "title": "title",
 *         "impact": 3,
 *         "dedupe_string": "dedupe",
 *         "incident_tags": {
 *             "key": "value",
 *         },
 *         "notification_targets": [
 *             {
 *                 "sns_topic_arn": example1["arn"],
 *             },
 *             {
 *                 "sns_topic_arn": example2["arn"],
 *             },
 *         ],
 *         "summary": "summary",
 *     },
 *     display_name="display name",
 *     chat_channels=[topic["arn"]],
 *     engagements=["arn:aws:ssm-contacts:us-east-2:111122223333:contact/test1"],
 *     action={
 *         "ssm_automations": [{
 *             "document_name": document1["name"],
 *             "role_arn": role1["arn"],
 *             "document_version": "version1",
 *             "target_account": "RESPONSE_PLAN_OWNER_ACCOUNT",
 *             "parameters": [
 *                 {
 *                     "name": "key",
 *                     "values": [
 *                         "value1",
 *                         "value2",
 *                     ],
 *                 },
 *                 {
 *                     "name": "foo",
 *                     "values": ["bar"],
 *                 },
 *             ],
 *             "dynamic_parameters": {
 *                 "some_key": "INVOLVED_RESOURCES",
 *                 "another_key": "INCIDENT_RECORD_ARN",
 *             },
 *         }],
 *     },
 *     integration={
 *         "pagerduties": [{
 *             "name": "pagerdutyIntergration",
 *             "service_id": "example",
 *             "secret_id": "example",
 *         }],
 *     },
 *     tags={
 *         "key": "value",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_ssmincidents_replication_set]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SsmIncidents.ResponsePlan("example", new()
 *     {
 *         Name = "name",
 *         IncidentTemplate = new Aws.SsmIncidents.Inputs.ResponsePlanIncidentTemplateArgs
 *         {
 *             Title = "title",
 *             Impact = 3,
 *             DedupeString = "dedupe",
 *             IncidentTags =
 *             {
 *                 { "key", "value" },
 *             },
 *             NotificationTargets = new[]
 *             {
 *                 new Aws.SsmIncidents.Inputs.ResponsePlanIncidentTemplateNotificationTargetArgs
 *                 {
 *                     SnsTopicArn = example1.Arn,
 *                 },
 *                 new Aws.SsmIncidents.Inputs.ResponsePlanIncidentTemplateNotificationTargetArgs
 *                 {
 *                     SnsTopicArn = example2.Arn,
 *                 },
 *             },
 *             Summary = "summary",
 *         },
 *         DisplayName = "display name",
 *         ChatChannels = new[]
 *         {
 *             topic.Arn,
 *         },
 *         Engagements = new[]
 *         {
 *             "arn:aws:ssm-contacts:us-east-2:111122223333:contact/test1",
 *         },
 *         Action = new Aws.SsmIncidents.Inputs.ResponsePlanActionArgs
 *         {
 *             SsmAutomations = new[]
 *             {
 *                 new Aws.SsmIncidents.Inputs.ResponsePlanActionSsmAutomationArgs
 *                 {
 *                     DocumentName = document1.Name,
 *                     RoleArn = role1.Arn,
 *                     DocumentVersion = "version1",
 *                     TargetAccount = "RESPONSE_PLAN_OWNER_ACCOUNT",
 *                     Parameters = new[]
 *                     {
 *                         new Aws.SsmIncidents.Inputs.ResponsePlanActionSsmAutomationParameterArgs
 *                         {
 *                             Name = "key",
 *                             Values = new[]
 *                             {
 *                                 "value1",
 *                                 "value2",
 *                             },
 *                         },
 *                         new Aws.SsmIncidents.Inputs.ResponsePlanActionSsmAutomationParameterArgs
 *                         {
 *                             Name = "foo",
 *                             Values = new[]
 *                             {
 *                                 "bar",
 *                             },
 *                         },
 *                     },
 *                     DynamicParameters =
 *                     {
 *                         { "someKey", "INVOLVED_RESOURCES" },
 *                         { "anotherKey", "INCIDENT_RECORD_ARN" },
 *                     },
 *                 },
 *             },
 *         },
 *         Integration = new Aws.SsmIncidents.Inputs.ResponsePlanIntegrationArgs
 *         {
 *             Pagerduties = new[]
 *             {
 *                 new Aws.SsmIncidents.Inputs.ResponsePlanIntegrationPagerdutyArgs
 *                 {
 *                     Name = "pagerdutyIntergration",
 *                     ServiceId = "example",
 *                     SecretId = "example",
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsSsmincidentsReplicationSet,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssmincidents"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssmincidents.NewResponsePlan(ctx, "example", &ssmincidents.ResponsePlanArgs{
 * 			Name: pulumi.String("name"),
 * 			IncidentTemplate: &ssmincidents.ResponsePlanIncidentTemplateArgs{
 * 				Title:        pulumi.String("title"),
 * 				Impact:       pulumi.Int(3),
 * 				DedupeString: pulumi.String("dedupe"),
 * 				IncidentTags: pulumi.StringMap{
 * 					"key": pulumi.String("value"),
 * 				},
 * 				NotificationTargets: ssmincidents.ResponsePlanIncidentTemplateNotificationTargetArray{
 * 					&ssmincidents.ResponsePlanIncidentTemplateNotificationTargetArgs{
 * 						SnsTopicArn: pulumi.Any(example1.Arn),
 * 					},
 * 					&ssmincidents.ResponsePlanIncidentTemplateNotificationTargetArgs{
 * 						SnsTopicArn: pulumi.Any(example2.Arn),
 * 					},
 * 				},
 * 				Summary: pulumi.String("summary"),
 * 			},
 * 			DisplayName: pulumi.String("display name"),
 * 			ChatChannels: pulumi.StringArray{
 * 				topic.Arn,
 * 			},
 * 			Engagements: pulumi.StringArray{
 * 				pulumi.String("arn:aws:ssm-contacts:us-east-2:111122223333:contact/test1"),
 * 			},
 * 			Action: &ssmincidents.ResponsePlanActionArgs{
 * 				SsmAutomations: ssmincidents.ResponsePlanActionSsmAutomationArray{
 * 					&ssmincidents.ResponsePlanActionSsmAutomationArgs{
 * 						DocumentName:    pulumi.Any(document1.Name),
 * 						RoleArn:         pulumi.Any(role1.Arn),
 * 						DocumentVersion: pulumi.String("version1"),
 * 						TargetAccount:   pulumi.String("RESPONSE_PLAN_OWNER_ACCOUNT"),
 * 						Parameters: ssmincidents.ResponsePlanActionSsmAutomationParameterArray{
 * 							&ssmincidents.ResponsePlanActionSsmAutomationParameterArgs{
 * 								Name: pulumi.String("key"),
 * 								Values: pulumi.StringArray{
 * 									pulumi.String("value1"),
 * 									pulumi.String("value2"),
 * 								},
 * 							},
 * 							&ssmincidents.ResponsePlanActionSsmAutomationParameterArgs{
 * 								Name: pulumi.String("foo"),
 * 								Values: pulumi.StringArray{
 * 									pulumi.String("bar"),
 * 								},
 * 							},
 * 						},
 * 						DynamicParameters: pulumi.StringMap{
 * 							"someKey":    pulumi.String("INVOLVED_RESOURCES"),
 * 							"anotherKey": pulumi.String("INCIDENT_RECORD_ARN"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Integration: &ssmincidents.ResponsePlanIntegrationArgs{
 * 				Pagerduties: ssmincidents.ResponsePlanIntegrationPagerdutyArray{
 * 					&ssmincidents.ResponsePlanIntegrationPagerdutyArgs{
 * 						Name:      pulumi.String("pagerdutyIntergration"),
 * 						ServiceId: pulumi.String("example"),
 * 						SecretId:  pulumi.String("example"),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsSsmincidentsReplicationSet,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmincidents.ResponsePlan;
 * import com.pulumi.aws.ssmincidents.ResponsePlanArgs;
 * import com.pulumi.aws.ssmincidents.inputs.ResponsePlanIncidentTemplateArgs;
 * import com.pulumi.aws.ssmincidents.inputs.ResponsePlanActionArgs;
 * import com.pulumi.aws.ssmincidents.inputs.ResponsePlanIntegrationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResponsePlan("example", ResponsePlanArgs.builder()
 *             .name("name")
 *             .incidentTemplate(ResponsePlanIncidentTemplateArgs.builder()
 *                 .title("title")
 *                 .impact("3")
 *                 .dedupeString("dedupe")
 *                 .incidentTags(Map.of("key", "value"))
 *                 .notificationTargets(
 *                     ResponsePlanIncidentTemplateNotificationTargetArgs.builder()
 *                         .snsTopicArn(example1.arn())
 *                         .build(),
 *                     ResponsePlanIncidentTemplateNotificationTargetArgs.builder()
 *                         .snsTopicArn(example2.arn())
 *                         .build())
 *                 .summary("summary")
 *                 .build())
 *             .displayName("display name")
 *             .chatChannels(topic.arn())
 *             .engagements("arn:aws:ssm-contacts:us-east-2:111122223333:contact/test1")
 *             .action(ResponsePlanActionArgs.builder()
 *                 .ssmAutomations(ResponsePlanActionSsmAutomationArgs.builder()
 *                     .documentName(document1.name())
 *                     .roleArn(role1.arn())
 *                     .documentVersion("version1")
 *                     .targetAccount("RESPONSE_PLAN_OWNER_ACCOUNT")
 *                     .parameters(
 *                         ResponsePlanActionSsmAutomationParameterArgs.builder()
 *                             .name("key")
 *                             .values(
 *                                 "value1",
 *                                 "value2")
 *                             .build(),
 *                         ResponsePlanActionSsmAutomationParameterArgs.builder()
 *                             .name("foo")
 *                             .values("bar")
 *                             .build())
 *                     .dynamicParameters(Map.ofEntries(
 *                         Map.entry("someKey", "INVOLVED_RESOURCES"),
 *                         Map.entry("anotherKey", "INCIDENT_RECORD_ARN")
 *                     ))
 *                     .build())
 *                 .build())
 *             .integration(ResponsePlanIntegrationArgs.builder()
 *                 .pagerduties(ResponsePlanIntegrationPagerdutyArgs.builder()
 *                     .name("pagerdutyIntergration")
 *                     .serviceId("example")
 *                     .secretId("example")
 *                     .build())
 *                 .build())
 *             .tags(Map.of("key", "value"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsSsmincidentsReplicationSet)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssmincidents:ResponsePlan
 *     properties:
 *       name: name
 *       incidentTemplate:
 *         title: title
 *         impact: '3'
 *         dedupeString: dedupe
 *         incidentTags:
 *           key: value
 *         notificationTargets:
 *           - snsTopicArn: ${example1.arn}
 *           - snsTopicArn: ${example2.arn}
 *         summary: summary
 *       displayName: display name
 *       chatChannels:
 *         - ${topic.arn}
 *       engagements:
 *         - arn:aws:ssm-contacts:us-east-2:111122223333:contact/test1
 *       action:
 *         ssmAutomations:
 *           - documentName: ${document1.name}
 *             roleArn: ${role1.arn}
 *             documentVersion: version1
 *             targetAccount: RESPONSE_PLAN_OWNER_ACCOUNT
 *             parameters:
 *               - name: key
 *                 values:
 *                   - value1
 *                   - value2
 *               - name: foo
 *                 values:
 *                   - bar
 *             dynamicParameters:
 *               someKey: INVOLVED_RESOURCES
 *               anotherKey: INCIDENT_RECORD_ARN
 *       integration:
 *         pagerduties:
 *           - name: pagerdutyIntergration
 *             serviceId: example
 *             secretId: example
 *       tags:
 *         key: value
 *     options:
 *       dependson:
 *         - ${exampleAwsSsmincidentsReplicationSet}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an Incident Manager response plan using the response plan ARN. You can find the response plan ARN in the AWS Management Console. For example:
 * ```sh
 * $ pulumi import aws:ssmincidents/responsePlan:ResponsePlan responsePlanName ARNValue
 * ```
 * @property action
 * @property chatChannels
 * @property displayName
 * @property engagements
 * @property incidentTemplate
 * @property integration
 * @property name The name of the response plan.
 * @property tags
 */
public data class ResponsePlanArgs(
    public val action: Output<ResponsePlanActionArgs>? = null,
    public val chatChannels: Output<List<String>>? = null,
    public val displayName: Output<String>? = null,
    public val engagements: Output<List<String>>? = null,
    public val incidentTemplate: Output<ResponsePlanIncidentTemplateArgs>? = null,
    public val integration: Output<ResponsePlanIntegrationArgs>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssmincidents.ResponsePlanArgs> {
    override fun toJava(): com.pulumi.aws.ssmincidents.ResponsePlanArgs =
        com.pulumi.aws.ssmincidents.ResponsePlanArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .chatChannels(chatChannels?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .engagements(engagements?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .incidentTemplate(incidentTemplate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .integration(integration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ResponsePlanArgs].
 */
@PulumiTagMarker
public class ResponsePlanArgsBuilder internal constructor() {
    private var action: Output<ResponsePlanActionArgs>? = null

    private var chatChannels: Output<List<String>>? = null

    private var displayName: Output<String>? = null

    private var engagements: Output<List<String>>? = null

    private var incidentTemplate: Output<ResponsePlanIncidentTemplateArgs>? = null

    private var integration: Output<ResponsePlanIntegrationArgs>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("umlvbauhibublmcb")
    public suspend fun action(`value`: Output<ResponsePlanActionArgs>) {
        this.action = value
    }

    /**
     * @param value
     */
    @JvmName("nfvuyxrhdeywudiy")
    public suspend fun chatChannels(`value`: Output<List<String>>) {
        this.chatChannels = value
    }

    @JvmName("scdbwvpkaahuuero")
    public suspend fun chatChannels(vararg values: Output<String>) {
        this.chatChannels = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("brxdjntlypepmhse")
    public suspend fun chatChannels(values: List<Output<String>>) {
        this.chatChannels = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("muluiecljwxglnob")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value
     */
    @JvmName("lhkvfeffwfmswbau")
    public suspend fun engagements(`value`: Output<List<String>>) {
        this.engagements = value
    }

    @JvmName("nphvdakbbdpubxrt")
    public suspend fun engagements(vararg values: Output<String>) {
        this.engagements = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ponjfolmpvmcvjvg")
    public suspend fun engagements(values: List<Output<String>>) {
        this.engagements = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("gwvflapdjndxhack")
    public suspend fun incidentTemplate(`value`: Output<ResponsePlanIncidentTemplateArgs>) {
        this.incidentTemplate = value
    }

    /**
     * @param value
     */
    @JvmName("gppmvgdkamxjkllp")
    public suspend fun integration(`value`: Output<ResponsePlanIntegrationArgs>) {
        this.integration = value
    }

    /**
     * @param value The name of the response plan.
     */
    @JvmName("pcnfdrhwgfxoggjp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("vbpymyvsbydfhijq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("mrtewdwrdegdphgg")
    public suspend fun action(`value`: ResponsePlanActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xodmjvaqpnhwxfpt")
    public suspend fun action(argument: suspend ResponsePlanActionArgsBuilder.() -> Unit) {
        val toBeMapped = ResponsePlanActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value
     */
    @JvmName("dttwvgbwlvtxtwoe")
    public suspend fun chatChannels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chatChannels = mapped
    }

    /**
     * @param values
     */
    @JvmName("llnxmhvhiddixwly")
    public suspend fun chatChannels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.chatChannels = mapped
    }

    /**
     * @param value
     */
    @JvmName("xbcopyekuvfkpbff")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value
     */
    @JvmName("kntleeiuiuodshkx")
    public suspend fun engagements(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engagements = mapped
    }

    /**
     * @param values
     */
    @JvmName("sllfcedovpavfdle")
    public suspend fun engagements(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.engagements = mapped
    }

    /**
     * @param value
     */
    @JvmName("lmuuqrmsoupxxqsl")
    public suspend fun incidentTemplate(`value`: ResponsePlanIncidentTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incidentTemplate = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mykhoafkaxohtpqx")
    public suspend fun incidentTemplate(argument: suspend ResponsePlanIncidentTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = ResponsePlanIncidentTemplateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.incidentTemplate = mapped
    }

    /**
     * @param value
     */
    @JvmName("eqrtusbychyakxgo")
    public suspend fun integration(`value`: ResponsePlanIntegrationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("utmpyvgoavdbcxni")
    public suspend fun integration(argument: suspend ResponsePlanIntegrationArgsBuilder.() -> Unit) {
        val toBeMapped = ResponsePlanIntegrationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.integration = mapped
    }

    /**
     * @param value The name of the response plan.
     */
    @JvmName("qjmoandkofrffcff")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("bycfglevjlgaeidf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("nmpdvfvecrdlbktx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ResponsePlanArgs = ResponsePlanArgs(
        action = action,
        chatChannels = chatChannels,
        displayName = displayName,
        engagements = engagements,
        incidentTemplate = incidentTemplate,
        integration = integration,
        name = name,
        tags = tags,
    )
}
