@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin.inputs

import com.pulumi.aws.ssmincidents.inputs.GetReplicationSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getReplicationSet.
 * @property tags All tags applied to the replication set.
 */
public data class GetReplicationSetPlainArgs(
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssmincidents.inputs.GetReplicationSetPlainArgs> {
    override fun toJava(): com.pulumi.aws.ssmincidents.inputs.GetReplicationSetPlainArgs =
        com.pulumi.aws.ssmincidents.inputs.GetReplicationSetPlainArgs.builder()
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetReplicationSetPlainArgs].
 */
@PulumiTagMarker
public class GetReplicationSetPlainArgsBuilder internal constructor() {
    private var tags: Map<String, String>? = null

    /**
     * @param value All tags applied to the replication set.
     */
    @JvmName("esymtegtojvojqrr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values All tags applied to the replication set.
     */
    @JvmName("comcrlqpmwverawl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetReplicationSetPlainArgs = GetReplicationSetPlainArgs(
        tags = tags,
    )
}
