@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin.inputs

import com.pulumi.aws.ssmincidents.inputs.ResponsePlanActionSsmAutomationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property documentName The automation document's name.
 * @property documentVersion The version of the automation document to use at runtime.
 * @property dynamicParameters The key-value pair to resolve dynamic parameter values when processing a Systems Manager Automation runbook.
 * @property parameters The key-value pair parameters to use when the automation document runs. The following values are supported:
 * @property roleArn The Amazon Resource Name (ARN) of the role that the automation document assumes when it runs commands.
 * @property targetAccount The account that the automation document runs in. This can be in either the management account or an application account.
 */
public data class ResponsePlanActionSsmAutomationArgs(
    public val documentName: Output<String>,
    public val documentVersion: Output<String>? = null,
    public val dynamicParameters: Output<Map<String, String>>? = null,
    public val parameters: Output<List<ResponsePlanActionSsmAutomationParameterArgs>>? = null,
    public val roleArn: Output<String>,
    public val targetAccount: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssmincidents.inputs.ResponsePlanActionSsmAutomationArgs> {
    override fun toJava(): com.pulumi.aws.ssmincidents.inputs.ResponsePlanActionSsmAutomationArgs =
        com.pulumi.aws.ssmincidents.inputs.ResponsePlanActionSsmAutomationArgs.builder()
            .documentName(documentName.applyValue({ args0 -> args0 }))
            .documentVersion(documentVersion?.applyValue({ args0 -> args0 }))
            .dynamicParameters(
                dynamicParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .targetAccount(targetAccount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResponsePlanActionSsmAutomationArgs].
 */
@PulumiTagMarker
public class ResponsePlanActionSsmAutomationArgsBuilder internal constructor() {
    private var documentName: Output<String>? = null

    private var documentVersion: Output<String>? = null

    private var dynamicParameters: Output<Map<String, String>>? = null

    private var parameters: Output<List<ResponsePlanActionSsmAutomationParameterArgs>>? = null

    private var roleArn: Output<String>? = null

    private var targetAccount: Output<String>? = null

    /**
     * @param value The automation document's name.
     */
    @JvmName("etilmxkqbubsleyo")
    public suspend fun documentName(`value`: Output<String>) {
        this.documentName = value
    }

    /**
     * @param value The version of the automation document to use at runtime.
     */
    @JvmName("apcbdxxliwierodp")
    public suspend fun documentVersion(`value`: Output<String>) {
        this.documentVersion = value
    }

    /**
     * @param value The key-value pair to resolve dynamic parameter values when processing a Systems Manager Automation runbook.
     */
    @JvmName("bruoriqsrbxqliow")
    public suspend fun dynamicParameters(`value`: Output<Map<String, String>>) {
        this.dynamicParameters = value
    }

    /**
     * @param value The key-value pair parameters to use when the automation document runs. The following values are supported:
     */
    @JvmName("gbauxypnjndcynss")
    public suspend fun parameters(`value`: Output<List<ResponsePlanActionSsmAutomationParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("sogvmhkprmlkpedv")
    public suspend fun parameters(vararg values: Output<ResponsePlanActionSsmAutomationParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values The key-value pair parameters to use when the automation document runs. The following values are supported:
     */
    @JvmName("djwehbsdxtxrvyjg")
    public suspend fun parameters(values: List<Output<ResponsePlanActionSsmAutomationParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the role that the automation document assumes when it runs commands.
     */
    @JvmName("kqvupefgbdsgnjfa")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The account that the automation document runs in. This can be in either the management account or an application account.
     */
    @JvmName("bulkhedvjkohqnis")
    public suspend fun targetAccount(`value`: Output<String>) {
        this.targetAccount = value
    }

    /**
     * @param value The automation document's name.
     */
    @JvmName("vntmgsxeiauxmtle")
    public suspend fun documentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.documentName = mapped
    }

    /**
     * @param value The version of the automation document to use at runtime.
     */
    @JvmName("rnymwnxycwwudedu")
    public suspend fun documentVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentVersion = mapped
    }

    /**
     * @param value The key-value pair to resolve dynamic parameter values when processing a Systems Manager Automation runbook.
     */
    @JvmName("sotodmfabhyyqpry")
    public suspend fun dynamicParameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamicParameters = mapped
    }

    /**
     * @param values The key-value pair to resolve dynamic parameter values when processing a Systems Manager Automation runbook.
     */
    @JvmName("wnaumxpqqnaauyja")
    public fun dynamicParameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dynamicParameters = mapped
    }

    /**
     * @param value The key-value pair parameters to use when the automation document runs. The following values are supported:
     */
    @JvmName("dweykpktelqsfqsu")
    public suspend fun parameters(`value`: List<ResponsePlanActionSsmAutomationParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The key-value pair parameters to use when the automation document runs. The following values are supported:
     */
    @JvmName("lrrphtngfnrsotvv")
    public suspend fun parameters(argument: List<suspend ResponsePlanActionSsmAutomationParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResponsePlanActionSsmAutomationParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The key-value pair parameters to use when the automation document runs. The following values are supported:
     */
    @JvmName("fqugwoflhvmkvyfa")
    public suspend fun parameters(vararg argument: suspend ResponsePlanActionSsmAutomationParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ResponsePlanActionSsmAutomationParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The key-value pair parameters to use when the automation document runs. The following values are supported:
     */
    @JvmName("oprsqamvorlhihft")
    public suspend fun parameters(argument: suspend ResponsePlanActionSsmAutomationParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ResponsePlanActionSsmAutomationParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The key-value pair parameters to use when the automation document runs. The following values are supported:
     */
    @JvmName("agnwctbxqspclfes")
    public suspend fun parameters(vararg values: ResponsePlanActionSsmAutomationParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the role that the automation document assumes when it runs commands.
     */
    @JvmName("dalwtrhdcnuvyvtk")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The account that the automation document runs in. This can be in either the management account or an application account.
     */
    @JvmName("saksydcpldwjwllx")
    public suspend fun targetAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAccount = mapped
    }

    internal fun build(): ResponsePlanActionSsmAutomationArgs = ResponsePlanActionSsmAutomationArgs(
        documentName = documentName ?: throw PulumiNullFieldException("documentName"),
        documentVersion = documentVersion,
        dynamicParameters = dynamicParameters,
        parameters = parameters,
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        targetAccount = targetAccount,
    )
}
