@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin.inputs

import com.pulumi.aws.ssmincidents.inputs.ResponsePlanIntegrationPagerdutyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the response plan.
 * @property secretId The ID of the AWS Secrets Manager secret that stores your PagerDuty key &mdash; either a General Access REST API Key or User Token REST API Key &mdash; and other user credentials.
 * For more information about the constraints for each field, see [CreateResponsePlan](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateResponsePlan.html) in the *AWS Systems Manager Incident Manager API Reference*.
 * @property serviceId The ID of the PagerDuty service that the response plan associated with the incident at launch.
 */
public data class ResponsePlanIntegrationPagerdutyArgs(
    public val name: Output<String>,
    public val secretId: Output<String>,
    public val serviceId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ssmincidents.inputs.ResponsePlanIntegrationPagerdutyArgs> {
    override fun toJava(): com.pulumi.aws.ssmincidents.inputs.ResponsePlanIntegrationPagerdutyArgs =
        com.pulumi.aws.ssmincidents.inputs.ResponsePlanIntegrationPagerdutyArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .secretId(secretId.applyValue({ args0 -> args0 }))
            .serviceId(serviceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResponsePlanIntegrationPagerdutyArgs].
 */
@PulumiTagMarker
public class ResponsePlanIntegrationPagerdutyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var secretId: Output<String>? = null

    private var serviceId: Output<String>? = null

    /**
     * @param value The name of the response plan.
     */
    @JvmName("atdemsbibkaaqkkb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID of the AWS Secrets Manager secret that stores your PagerDuty key &mdash; either a General Access REST API Key or User Token REST API Key &mdash; and other user credentials.
     * For more information about the constraints for each field, see [CreateResponsePlan](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateResponsePlan.html) in the *AWS Systems Manager Incident Manager API Reference*.
     */
    @JvmName("pxtawiarkmhffaqp")
    public suspend fun secretId(`value`: Output<String>) {
        this.secretId = value
    }

    /**
     * @param value The ID of the PagerDuty service that the response plan associated with the incident at launch.
     */
    @JvmName("edpwbaoreurbmbya")
    public suspend fun serviceId(`value`: Output<String>) {
        this.serviceId = value
    }

    /**
     * @param value The name of the response plan.
     */
    @JvmName("emjtulqgecymhcnb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ID of the AWS Secrets Manager secret that stores your PagerDuty key &mdash; either a General Access REST API Key or User Token REST API Key &mdash; and other user credentials.
     * For more information about the constraints for each field, see [CreateResponsePlan](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateResponsePlan.html) in the *AWS Systems Manager Incident Manager API Reference*.
     */
    @JvmName("vocicxpkqjwchhla")
    public suspend fun secretId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretId = mapped
    }

    /**
     * @param value The ID of the PagerDuty service that the response plan associated with the incident at launch.
     */
    @JvmName("dtkernauxyynhopg")
    public suspend fun serviceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceId = mapped
    }

    internal fun build(): ResponsePlanIntegrationPagerdutyArgs = ResponsePlanIntegrationPagerdutyArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        secretId = secretId ?: throw PulumiNullFieldException("secretId"),
        serviceId = serviceId ?: throw PulumiNullFieldException("serviceId"),
    )
}
