@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getReplicationSet.
 * @property arn The Amazon Resouce Name (ARN) of the replication set.
 * @property createdBy The ARN of the user who created the replication set.
 * @property deletionProtected If `true`, the last remaining Region in a replication set can’t be deleted.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lastModifiedBy The ARN of the user who last modified the replication set.
 * @property regions
 * @property status The current status of the Region.
 * * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
 * @property tags All tags applied to the replication set.
 */
public data class GetReplicationSetResult(
    public val arn: String,
    public val createdBy: String,
    public val deletionProtected: Boolean,
    public val id: String,
    public val lastModifiedBy: String,
    public val regions: List<GetReplicationSetRegion>,
    public val status: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssmincidents.outputs.GetReplicationSetResult): GetReplicationSetResult = GetReplicationSetResult(
            arn = javaType.arn(),
            createdBy = javaType.createdBy(),
            deletionProtected = javaType.deletionProtected(),
            id = javaType.id(),
            lastModifiedBy = javaType.lastModifiedBy(),
            regions = javaType.regions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssmincidents.kotlin.outputs.GetReplicationSetRegion.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
