@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property documentName The automation document's name.
 * @property documentVersion The version of the automation document to use at runtime.
 * @property dynamicParameters The key-value pair to resolve dynamic parameter values when processing a Systems Manager Automation runbook.
 * @property parameters The key-value pair parameters to use when the automation document runs. The following values are supported:
 * @property roleArn The Amazon Resource Name (ARN) of the role that the automation document assumes when it runs commands.
 * @property targetAccount The account that the automation document runs in. This can be in either the management account or an application account.
 */
public data class ResponsePlanActionSsmAutomation(
    public val documentName: String,
    public val documentVersion: String? = null,
    public val dynamicParameters: Map<String, String>? = null,
    public val parameters: List<ResponsePlanActionSsmAutomationParameter>? = null,
    public val roleArn: String,
    public val targetAccount: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssmincidents.outputs.ResponsePlanActionSsmAutomation): ResponsePlanActionSsmAutomation = ResponsePlanActionSsmAutomation(
            documentName = javaType.documentName(),
            documentVersion = javaType.documentVersion().map({ args0 -> args0 }).orElse(null),
            dynamicParameters = javaType.dynamicParameters().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssmincidents.kotlin.outputs.ResponsePlanActionSsmAutomationParameter.Companion.toKotlin(args0)
                })
            }),
            roleArn = javaType.roleArn(),
            targetAccount = javaType.targetAccount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
