@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name The name of the response plan.
 * @property secretId The ID of the AWS Secrets Manager secret that stores your PagerDuty key &mdash; either a General Access REST API Key or User Token REST API Key &mdash; and other user credentials.
 * For more information about the constraints for each field, see [CreateResponsePlan](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateResponsePlan.html) in the *AWS Systems Manager Incident Manager API Reference*.
 * @property serviceId The ID of the PagerDuty service that the response plan associated with the incident at launch.
 */
public data class ResponsePlanIntegrationPagerduty(
    public val name: String,
    public val secretId: String,
    public val serviceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssmincidents.outputs.ResponsePlanIntegrationPagerduty): ResponsePlanIntegrationPagerduty = ResponsePlanIntegrationPagerduty(
            name = javaType.name(),
            secretId = javaType.secretId(),
            serviceId = javaType.serviceId(),
        )
    }
}
