@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccountAssignment].
 */
@PulumiTagMarker
public class AccountAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountAssignmentArgs = AccountAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountAssignmentArgsBuilder.() -> Unit) {
        val builder = AccountAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccountAssignment {
        val builtJavaResource = com.pulumi.aws.ssoadmin.AccountAssignment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccountAssignment(builtJavaResource)
    }
}

/**
 * Provides a Single Sign-On (SSO) Account Assignment resource
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.ssoadmin.getInstances({});
 * const exampleGetPermissionSet = example.then(example => aws.ssoadmin.getPermissionSet({
 *     instanceArn: example.arns?.[0],
 *     name: "AWSReadOnlyAccess",
 * }));
 * const exampleGetGroup = example.then(example => aws.identitystore.getGroup({
 *     identityStoreId: example.identityStoreIds?.[0],
 *     alternateIdentifier: {
 *         uniqueAttribute: {
 *             attributePath: "DisplayName",
 *             attributeValue: "ExampleGroup",
 *         },
 *     },
 * }));
 * const exampleAccountAssignment = new aws.ssoadmin.AccountAssignment("example", {
 *     instanceArn: example.then(example => example.arns?.[0]),
 *     permissionSetArn: exampleGetPermissionSet.then(exampleGetPermissionSet => exampleGetPermissionSet.arn),
 *     principalId: exampleGetGroup.then(exampleGetGroup => exampleGetGroup.groupId),
 *     principalType: "GROUP",
 *     targetId: "123456789012",
 *     targetType: "AWS_ACCOUNT",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.get_instances()
 * example_get_permission_set = aws.ssoadmin.get_permission_set(instance_arn=example.arns[0],
 *     name="AWSReadOnlyAccess")
 * example_get_group = aws.identitystore.get_group(identity_store_id=example.identity_store_ids[0],
 *     alternate_identifier={
 *         "unique_attribute": {
 *             "attribute_path": "DisplayName",
 *             "attribute_value": "ExampleGroup",
 *         },
 *     })
 * example_account_assignment = aws.ssoadmin.AccountAssignment("example",
 *     instance_arn=example.arns[0],
 *     permission_set_arn=example_get_permission_set.arn,
 *     principal_id=example_get_group.group_id,
 *     principal_type="GROUP",
 *     target_id="123456789012",
 *     target_type="AWS_ACCOUNT")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.SsoAdmin.GetInstances.Invoke();
 *     var exampleGetPermissionSet = Aws.SsoAdmin.GetPermissionSet.Invoke(new()
 *     {
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *         Name = "AWSReadOnlyAccess",
 *     });
 *     var exampleGetGroup = Aws.IdentityStore.GetGroup.Invoke(new()
 *     {
 *         IdentityStoreId = example.Apply(getInstancesResult => getInstancesResult.IdentityStoreIds[0]),
 *         AlternateIdentifier = new Aws.IdentityStore.Inputs.GetGroupAlternateIdentifierInputArgs
 *         {
 *             UniqueAttribute = new Aws.IdentityStore.Inputs.GetGroupAlternateIdentifierUniqueAttributeInputArgs
 *             {
 *                 AttributePath = "DisplayName",
 *                 AttributeValue = "ExampleGroup",
 *             },
 *         },
 *     });
 *     var exampleAccountAssignment = new Aws.SsoAdmin.AccountAssignment("example", new()
 *     {
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *         PermissionSetArn = exampleGetPermissionSet.Apply(getPermissionSetResult => getPermissionSetResult.Arn),
 *         PrincipalId = exampleGetGroup.Apply(getGroupResult => getGroupResult.GroupId),
 *         PrincipalType = "GROUP",
 *         TargetId = "123456789012",
 *         TargetType = "AWS_ACCOUNT",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/identitystore"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetPermissionSet, err := ssoadmin.LookupPermissionSet(ctx, &ssoadmin.LookupPermissionSetArgs{
 * 			InstanceArn: example.Arns[0],
 * 			Name:        pulumi.StringRef("AWSReadOnlyAccess"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetGroup, err := identitystore.LookupGroup(ctx, &identitystore.LookupGroupArgs{
 * 			IdentityStoreId: example.IdentityStoreIds[0],
 * 			AlternateIdentifier: identitystore.GetGroupAlternateIdentifier{
 * 				UniqueAttribute: identitystore.GetGroupAlternateIdentifierUniqueAttribute{
 * 					AttributePath:  "DisplayName",
 * 					AttributeValue: "ExampleGroup",
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssoadmin.NewAccountAssignment(ctx, "example", &ssoadmin.AccountAssignmentArgs{
 * 			InstanceArn:      pulumi.String(example.Arns[0]),
 * 			PermissionSetArn: pulumi.String(exampleGetPermissionSet.Arn),
 * 			PrincipalId:      pulumi.String(exampleGetGroup.GroupId),
 * 			PrincipalType:    pulumi.String("GROUP"),
 * 			TargetId:         pulumi.String("123456789012"),
 * 			TargetType:       pulumi.String("AWS_ACCOUNT"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
 * import com.pulumi.aws.ssoadmin.inputs.GetPermissionSetArgs;
 * import com.pulumi.aws.identitystore.IdentitystoreFunctions;
 * import com.pulumi.aws.identitystore.inputs.GetGroupArgs;
 * import com.pulumi.aws.identitystore.inputs.GetGroupAlternateIdentifierArgs;
 * import com.pulumi.aws.identitystore.inputs.GetGroupAlternateIdentifierUniqueAttributeArgs;
 * import com.pulumi.aws.ssoadmin.AccountAssignment;
 * import com.pulumi.aws.ssoadmin.AccountAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = SsoadminFunctions.getInstances();
 *         final var exampleGetPermissionSet = SsoadminFunctions.getPermissionSet(GetPermissionSetArgs.builder()
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .name("AWSReadOnlyAccess")
 *             .build());
 *         final var exampleGetGroup = IdentitystoreFunctions.getGroup(GetGroupArgs.builder()
 *             .identityStoreId(example.applyValue(getInstancesResult -> getInstancesResult.identityStoreIds()[0]))
 *             .alternateIdentifier(GetGroupAlternateIdentifierArgs.builder()
 *                 .uniqueAttribute(GetGroupAlternateIdentifierUniqueAttributeArgs.builder()
 *                     .attributePath("DisplayName")
 *                     .attributeValue("ExampleGroup")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleAccountAssignment = new AccountAssignment("exampleAccountAssignment", AccountAssignmentArgs.builder()
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .permissionSetArn(exampleGetPermissionSet.applyValue(getPermissionSetResult -> getPermissionSetResult.arn()))
 *             .principalId(exampleGetGroup.applyValue(getGroupResult -> getGroupResult.groupId()))
 *             .principalType("GROUP")
 *             .targetId("123456789012")
 *             .targetType("AWS_ACCOUNT")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleAccountAssignment:
 *     type: aws:ssoadmin:AccountAssignment
 *     name: example
 *     properties:
 *       instanceArn: ${example.arns[0]}
 *       permissionSetArn: ${exampleGetPermissionSet.arn}
 *       principalId: ${exampleGetGroup.groupId}
 *       principalType: GROUP
 *       targetId: '123456789012'
 *       targetType: AWS_ACCOUNT
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ssoadmin:getInstances
 *       Arguments: {}
 *   exampleGetPermissionSet:
 *     fn::invoke:
 *       Function: aws:ssoadmin:getPermissionSet
 *       Arguments:
 *         instanceArn: ${example.arns[0]}
 *         name: AWSReadOnlyAccess
 *   exampleGetGroup:
 *     fn::invoke:
 *       Function: aws:identitystore:getGroup
 *       Arguments:
 *         identityStoreId: ${example.identityStoreIds[0]}
 *         alternateIdentifier:
 *           uniqueAttribute:
 *             attributePath: DisplayName
 *             attributeValue: ExampleGroup
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Managed Policy Attachment
 * > Because destruction of a managed policy attachment resource also re-provisions the associated permission set to all accounts, explicitly indicating the dependency with the account assignment resource via the `depends_on` meta argument is necessary to ensure proper deletion order when these resources are used together.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.ssoadmin.getInstances({});
 * const examplePermissionSet = new aws.ssoadmin.PermissionSet("example", {
 *     name: "Example",
 *     instanceArn: example.then(example => example.arns?.[0]),
 * });
 * const exampleGroup = new aws.identitystore.Group("example", {
 *     identityStoreId: example.then(example => example.identityStoreIds?.[0]),
 *     displayName: "Admin",
 *     description: "Admin Group",
 * });
 * const accountAssignment = new aws.ssoadmin.AccountAssignment("account_assignment", {
 *     instanceArn: example.then(example => example.arns?.[0]),
 *     permissionSetArn: examplePermissionSet.arn,
 *     principalId: exampleGroup.groupId,
 *     principalType: "GROUP",
 *     targetId: "123456789012",
 *     targetType: "AWS_ACCOUNT",
 * });
 * const exampleManagedPolicyAttachment = new aws.ssoadmin.ManagedPolicyAttachment("example", {
 *     instanceArn: example.then(example => example.arns?.[0]),
 *     managedPolicyArn: "arn:aws:iam::aws:policy/AlexaForBusinessDeviceSetup",
 *     permissionSetArn: examplePermissionSet.arn,
 * }, {
 *     dependsOn: [exampleAwsSsoadminAccountAssignment],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.get_instances()
 * example_permission_set = aws.ssoadmin.PermissionSet("example",
 *     name="Example",
 *     instance_arn=example.arns[0])
 * example_group = aws.identitystore.Group("example",
 *     identity_store_id=example.identity_store_ids[0],
 *     display_name="Admin",
 *     description="Admin Group")
 * account_assignment = aws.ssoadmin.AccountAssignment("account_assignment",
 *     instance_arn=example.arns[0],
 *     permission_set_arn=example_permission_set.arn,
 *     principal_id=example_group.group_id,
 *     principal_type="GROUP",
 *     target_id="123456789012",
 *     target_type="AWS_ACCOUNT")
 * example_managed_policy_attachment = aws.ssoadmin.ManagedPolicyAttachment("example",
 *     instance_arn=example.arns[0],
 *     managed_policy_arn="arn:aws:iam::aws:policy/AlexaForBusinessDeviceSetup",
 *     permission_set_arn=example_permission_set.arn,
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_ssoadmin_account_assignment]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.SsoAdmin.GetInstances.Invoke();
 *     var examplePermissionSet = new Aws.SsoAdmin.PermissionSet("example", new()
 *     {
 *         Name = "Example",
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *     });
 *     var exampleGroup = new Aws.IdentityStore.Group("example", new()
 *     {
 *         IdentityStoreId = example.Apply(getInstancesResult => getInstancesResult.IdentityStoreIds[0]),
 *         DisplayName = "Admin",
 *         Description = "Admin Group",
 *     });
 *     var accountAssignment = new Aws.SsoAdmin.AccountAssignment("account_assignment", new()
 *     {
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *         PermissionSetArn = examplePermissionSet.Arn,
 *         PrincipalId = exampleGroup.GroupId,
 *         PrincipalType = "GROUP",
 *         TargetId = "123456789012",
 *         TargetType = "AWS_ACCOUNT",
 *     });
 *     var exampleManagedPolicyAttachment = new Aws.SsoAdmin.ManagedPolicyAttachment("example", new()
 *     {
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *         ManagedPolicyArn = "arn:aws:iam::aws:policy/AlexaForBusinessDeviceSetup",
 *         PermissionSetArn = examplePermissionSet.Arn,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsSsoadminAccountAssignment,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/identitystore"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		examplePermissionSet, err := ssoadmin.NewPermissionSet(ctx, "example", &ssoadmin.PermissionSetArgs{
 * 			Name:        pulumi.String("Example"),
 * 			InstanceArn: pulumi.String(example.Arns[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGroup, err := identitystore.NewGroup(ctx, "example", &identitystore.GroupArgs{
 * 			IdentityStoreId: pulumi.String(example.IdentityStoreIds[0]),
 * 			DisplayName:     pulumi.String("Admin"),
 * 			Description:     pulumi.String("Admin Group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssoadmin.NewAccountAssignment(ctx, "account_assignment", &ssoadmin.AccountAssignmentArgs{
 * 			InstanceArn:      pulumi.String(example.Arns[0]),
 * 			PermissionSetArn: examplePermissionSet.Arn,
 * 			PrincipalId:      exampleGroup.GroupId,
 * 			PrincipalType:    pulumi.String("GROUP"),
 * 			TargetId:         pulumi.String("123456789012"),
 * 			TargetType:       pulumi.String("AWS_ACCOUNT"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssoadmin.NewManagedPolicyAttachment(ctx, "example", &ssoadmin.ManagedPolicyAttachmentArgs{
 * 			InstanceArn:      pulumi.String(example.Arns[0]),
 * 			ManagedPolicyArn: pulumi.String("arn:aws:iam::aws:policy/AlexaForBusinessDeviceSetup"),
 * 			PermissionSetArn: examplePermissionSet.Arn,
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsSsoadminAccountAssignment,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
 * import com.pulumi.aws.ssoadmin.PermissionSet;
 * import com.pulumi.aws.ssoadmin.PermissionSetArgs;
 * import com.pulumi.aws.identitystore.Group;
 * import com.pulumi.aws.identitystore.GroupArgs;
 * import com.pulumi.aws.ssoadmin.AccountAssignment;
 * import com.pulumi.aws.ssoadmin.AccountAssignmentArgs;
 * import com.pulumi.aws.ssoadmin.ManagedPolicyAttachment;
 * import com.pulumi.aws.ssoadmin.ManagedPolicyAttachmentArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = SsoadminFunctions.getInstances();
 *         var examplePermissionSet = new PermissionSet("examplePermissionSet", PermissionSetArgs.builder()
 *             .name("Example")
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .build());
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .identityStoreId(example.applyValue(getInstancesResult -> getInstancesResult.identityStoreIds()[0]))
 *             .displayName("Admin")
 *             .description("Admin Group")
 *             .build());
 *         var accountAssignment = new AccountAssignment("accountAssignment", AccountAssignmentArgs.builder()
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .permissionSetArn(examplePermissionSet.arn())
 *             .principalId(exampleGroup.groupId())
 *             .principalType("GROUP")
 *             .targetId("123456789012")
 *             .targetType("AWS_ACCOUNT")
 *             .build());
 *         var exampleManagedPolicyAttachment = new ManagedPolicyAttachment("exampleManagedPolicyAttachment", ManagedPolicyAttachmentArgs.builder()
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .managedPolicyArn("arn:aws:iam::aws:policy/AlexaForBusinessDeviceSetup")
 *             .permissionSetArn(examplePermissionSet.arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsSsoadminAccountAssignment)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   examplePermissionSet:
 *     type: aws:ssoadmin:PermissionSet
 *     name: example
 *     properties:
 *       name: Example
 *       instanceArn: ${example.arns[0]}
 *   exampleGroup:
 *     type: aws:identitystore:Group
 *     name: example
 *     properties:
 *       identityStoreId: ${example.identityStoreIds[0]}
 *       displayName: Admin
 *       description: Admin Group
 *   accountAssignment:
 *     type: aws:ssoadmin:AccountAssignment
 *     name: account_assignment
 *     properties:
 *       instanceArn: ${example.arns[0]}
 *       permissionSetArn: ${examplePermissionSet.arn}
 *       principalId: ${exampleGroup.groupId}
 *       principalType: GROUP
 *       targetId: '123456789012'
 *       targetType: AWS_ACCOUNT
 *   exampleManagedPolicyAttachment:
 *     type: aws:ssoadmin:ManagedPolicyAttachment
 *     name: example
 *     properties:
 *       instanceArn: ${example.arns[0]}
 *       managedPolicyArn: arn:aws:iam::aws:policy/AlexaForBusinessDeviceSetup
 *       permissionSetArn: ${examplePermissionSet.arn}
 *     options:
 *       dependson:
 *         - ${exampleAwsSsoadminAccountAssignment}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ssoadmin:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSO Account Assignments using the `principal_id`, `principal_type`, `target_id`, `target_type`, `permission_set_arn`, `instance_arn` separated by commas (`,`). For example:
 * ```sh
 * $ pulumi import aws:ssoadmin/accountAssignment:AccountAssignment example f81d4fae-7dec-11d0-a765-00a0c91e6bf6,GROUP,1234567890,AWS_ACCOUNT,arn:aws:sso:::permissionSet/ssoins-0123456789abcdef/ps-0123456789abcdef,arn:aws:sso:::instance/ssoins-0123456789abcdef
 * ```
 */
public class AccountAssignment internal constructor(
    override val javaResource: com.pulumi.aws.ssoadmin.AccountAssignment,
) : KotlinCustomResource(javaResource, AccountAssignmentMapper) {
    /**
     * The Amazon Resource Name (ARN) of the SSO Instance.
     */
    public val instanceArn: Output<String>
        get() = javaResource.instanceArn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the Permission Set that the admin wants to grant the principal access to.
     */
    public val permissionSetArn: Output<String>
        get() = javaResource.permissionSetArn().applyValue({ args0 -> args0 })

    /**
     * An identifier for an object in SSO, such as a user or group. PrincipalIds are GUIDs (For example, `f81d4fae-7dec-11d0-a765-00a0c91e6bf6`).
     */
    public val principalId: Output<String>
        get() = javaResource.principalId().applyValue({ args0 -> args0 })

    /**
     * The entity type for which the assignment will be created. Valid values: `USER`, `GROUP`.
     */
    public val principalType: Output<String>
        get() = javaResource.principalType().applyValue({ args0 -> args0 })

    /**
     * An AWS account identifier, typically a 10-12 digit string.
     */
    public val targetId: Output<String>
        get() = javaResource.targetId().applyValue({ args0 -> args0 })

    /**
     * The entity type for which the assignment will be created. Valid values: `AWS_ACCOUNT`.
     */
    public val targetType: Output<String>?
        get() = javaResource.targetType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AccountAssignmentMapper : ResourceMapper<AccountAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssoadmin.AccountAssignment::class == javaResource::class

    override fun map(javaResource: Resource): AccountAssignment = AccountAssignment(
        javaResource as
            com.pulumi.aws.ssoadmin.AccountAssignment,
    )
}

/**
 * @see [AccountAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccountAssignment].
 */
public suspend fun accountAssignment(
    name: String,
    block: suspend AccountAssignmentResourceBuilder.() -> Unit,
): AccountAssignment {
    val builder = AccountAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccountAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accountAssignment(name: String): AccountAssignment {
    val builder = AccountAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
